/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.sqlclient;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.vertx.mutiny.sqlclient.Pool;
import io.vertx.mutiny.sqlclient.SqlClient;
import io.vertx.mutiny.sqlclient.SqlConnection;
import io.vertx.mutiny.sqlclient.Transaction;
import io.vertx.sqlclient.TransactionRollbackException;
import java.util.function.Function;

public class SqlClientHelper {
    public static <T> Multi<T> inTransactionMulti(Pool pool, Function<SqlClient, Multi<T>> sourceSupplier) {
        return SqlClientHelper.usingConnectionMulti(pool, conn -> conn.begin().onItem().transformToMulti(tx -> ((Multi)sourceSupplier.apply((SqlClient)conn)).onCompletion().call(tx::commit).onFailure(SqlClientHelper::needsRollback).recoverWithMulti(err -> SqlClientHelper.rollbackMulti(tx, err))));
    }

    private static <T> Multi<T> rollbackMulti(Transaction tx, Throwable originalErr) {
        return SqlClientHelper.rollbackUni(tx, originalErr).toMulti();
    }

    public static <T> Uni<T> inTransactionUni(Pool pool, Function<SqlClient, Uni<T>> sourceSupplier) {
        return SqlClientHelper.usingConnectionUni(pool, conn -> conn.begin().onItem().transformToUni(tx -> ((Uni)sourceSupplier.apply((SqlClient)conn)).onItem().call(tx::commit).onFailure(SqlClientHelper::needsRollback).recoverWithUni(err -> SqlClientHelper.rollbackUni(tx, err))));
    }

    private static boolean needsRollback(Throwable throwable) {
        return !(throwable instanceof TransactionRollbackException);
    }

    private static <T> Uni<T> rollbackUni(Transaction tx, Throwable originalErr) {
        return tx.rollback().onItemOrFailure().transformToUni((res, err) -> {
            if (err != null) {
                originalErr.addSuppressed((Throwable)err);
            }
            return Uni.createFrom().failure(originalErr);
        });
    }

    public static <T> Multi<T> usingConnectionMulti(Pool pool, Function<SqlConnection, Multi<T>> sourceSupplier) {
        return pool.getConnection().onItem().transformToMulti(conn -> {
            try {
                return ((Multi)sourceSupplier.apply((SqlConnection)conn)).onTermination().call(conn::close);
            }
            catch (Throwable t) {
                return conn.close().onItem().transformToMulti(x -> Multi.createFrom().failure(t));
            }
        });
    }

    public static <T> Uni<T> usingConnectionUni(Pool pool, Function<SqlConnection, Uni<T>> sourceSupplier) {
        return pool.getConnection().onItem().transformToUni(conn -> {
            try {
                return ((Uni)sourceSupplier.apply((SqlConnection)conn)).onTermination().call(conn::close);
            }
            catch (Throwable t) {
                return conn.close().onItem().failWith(x -> t);
            }
        });
    }

    private SqlClientHelper() {
    }
}

