/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.sqlclient;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.mutiny.sqlclient.PreparedQuery;
import io.vertx.mutiny.sqlclient.Query;
import io.vertx.mutiny.sqlclient.Row;
import io.vertx.mutiny.sqlclient.RowSet;
import io.vertx.mutiny.sqlclient.SqlClient;
import io.vertx.mutiny.sqlclient.SqlConnection;
import io.vertx.mutiny.sqlclient.Transaction;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;

@MutinyGen(value=io.vertx.sqlclient.Pool.class)
public class Pool
extends SqlClient {
    public static final TypeArg<Pool> __TYPE_ARG = new TypeArg(obj -> new Pool((io.vertx.sqlclient.Pool)obj), Pool::getDelegate);
    private final io.vertx.sqlclient.Pool delegate;
    static final TypeArg<RowSet<Row>> TYPE_ARG_1 = new TypeArg(o1 -> RowSet.newInstance((io.vertx.sqlclient.RowSet)o1, new TypeArg(o2 -> Row.newInstance((io.vertx.sqlclient.Row)o2), o2 -> o2.getDelegate())), o1 -> o1.getDelegate());
    static final TypeArg<RowSet<Row>> TYPE_ARG_0 = new TypeArg(o1 -> RowSet.newInstance((io.vertx.sqlclient.RowSet)o1, new TypeArg(o2 -> Row.newInstance((io.vertx.sqlclient.Row)o2), o2 -> o2.getDelegate())), o1 -> o1.getDelegate());

    public Pool(io.vertx.sqlclient.Pool delegate) {
        super((io.vertx.sqlclient.SqlClient)delegate);
        this.delegate = delegate;
    }

    Pool() {
        super(null);
        this.delegate = null;
    }

    public io.vertx.sqlclient.Pool getDelegate() {
        return this.delegate;
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pool that = (Pool)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public static Pool pool(SqlConnectOptions connectOptions) {
        Pool ret = Pool.newInstance(io.vertx.sqlclient.Pool.pool((SqlConnectOptions)connectOptions));
        return ret;
    }

    public static Pool pool(SqlConnectOptions connectOptions, PoolOptions poolOptions) {
        Pool ret = Pool.newInstance(io.vertx.sqlclient.Pool.pool((SqlConnectOptions)connectOptions, (PoolOptions)poolOptions));
        return ret;
    }

    public static Pool pool(io.vertx.mutiny.core.Vertx vertx, SqlConnectOptions connectOptions, PoolOptions poolOptions) {
        Pool ret = Pool.newInstance(io.vertx.sqlclient.Pool.pool((Vertx)vertx.getDelegate(), (SqlConnectOptions)connectOptions, (PoolOptions)poolOptions));
        return ret;
    }

    private void __getConnection(final Handler<AsyncResult<SqlConnection>> handler) {
        this.delegate.getConnection((Handler)new Handler<AsyncResult<io.vertx.sqlclient.SqlConnection>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.SqlConnection> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)SqlConnection.newInstance((io.vertx.sqlclient.SqlConnection)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Uni<SqlConnection> getConnection() {
        return AsyncResultUni.toUni(handler -> this.__getConnection((Handler<AsyncResult<SqlConnection>>)handler));
    }

    public SqlConnection getConnectionAndAwait() {
        return (SqlConnection)this.getConnection().await().indefinitely();
    }

    @Override
    public Query<RowSet<Row>> query(String sql) {
        Query<RowSet<Row>> ret = Query.newInstance(this.delegate.query(sql), TYPE_ARG_0);
        return ret;
    }

    @Override
    public PreparedQuery<RowSet<Row>> preparedQuery(String sql) {
        PreparedQuery<RowSet<Row>> ret = PreparedQuery.newInstance(this.delegate.preparedQuery(sql), TYPE_ARG_1);
        return ret;
    }

    private void __begin(final Handler<AsyncResult<Transaction>> handler) {
        this.delegate.begin((Handler)new Handler<AsyncResult<io.vertx.sqlclient.Transaction>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.Transaction> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Transaction.newInstance((io.vertx.sqlclient.Transaction)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public Uni<Transaction> begin() {
        return AsyncResultUni.toUni(handler -> this.__begin((Handler<AsyncResult<Transaction>>)handler));
    }

    public Transaction beginAndAwait() {
        return (Transaction)this.begin().await().indefinitely();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    public static Pool newInstance(io.vertx.sqlclient.Pool arg) {
        return arg != null ? new Pool(arg) : null;
    }
}

