/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.vertx.impl;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.vertx.WriteStreamSubscriber;
import io.vertx.core.streams.WriteStream;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import org.reactivestreams.Subscription;

public class WriteStreamSubscriberImpl<I, O>
implements WriteStreamSubscriber<I> {
    private static final int BATCH_SIZE = 16;
    private final WriteStream<O> stream;
    private final Function<I, O> mapping;
    private AtomicReference<Subscription> upstream = new AtomicReference();
    private AtomicBoolean done = new AtomicBoolean();
    private int outstanding;
    private Consumer<? super Throwable> onFailure;
    private Runnable onCompletion;
    private Consumer<? super Throwable> onStreamFailure;

    public WriteStreamSubscriberImpl(WriteStream<O> stream, Function<I, O> mapping) {
        this.stream = (WriteStream)ParameterValidation.nonNull(stream, (String)"writeStream");
        this.mapping = (Function)ParameterValidation.nonNull(mapping, (String)"mapping");
    }

    public void onSubscribe(Subscription subscription) {
        ParameterValidation.nonNullNpe((Object)subscription, (String)"upstream");
        if (this.upstream.compareAndSet(null, subscription)) {
            this.stream.exceptionHandler(t -> {
                Consumer<? super Throwable> onFailureCallback;
                if (this.done.getAndSet(true)) {
                    return;
                }
                this.cancel();
                WriteStreamSubscriberImpl writeStreamSubscriberImpl = this;
                synchronized (writeStreamSubscriberImpl) {
                    onFailureCallback = this.onStreamFailure;
                }
                if (onFailureCallback != null) {
                    try {
                        onFailureCallback.accept((Throwable)t);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            this.stream.drainHandler(v -> this.requestMore());
            this.requestMore();
        } else {
            subscription.cancel();
        }
    }

    private void cancel() {
        Subscriptions.cancel(this.upstream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNext(I item) {
        if (!this.done.get()) {
            return;
        }
        if (item == null) {
            NullPointerException throwable = new NullPointerException("onNext called with null");
            try {
                this.cancel();
            }
            catch (Throwable t) {
                throwable = new CompositeException(new Throwable[]{throwable, t});
            }
            this.onError(throwable);
            return;
        }
        try {
            this.stream.write(this.mapping.apply(item));
            WriteStreamSubscriberImpl throwable = this;
            synchronized (throwable) {
                --this.outstanding;
            }
        }
        catch (Throwable t) {
            Throwable throwable;
            try {
                this.cancel();
                throwable = t;
            }
            catch (Throwable t1) {
                throwable = new CompositeException(new Throwable[]{t, t1});
            }
            this.onError(throwable);
            return;
        }
        if (!this.stream.writeQueueFull()) {
            this.requestMore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Throwable failure) {
        Consumer<? super Throwable> c;
        if (this.done.getAndSet(true)) {
            return;
        }
        ParameterValidation.nonNullNpe((Object)failure, (String)"failure");
        WriteStreamSubscriberImpl writeStreamSubscriberImpl = this;
        synchronized (writeStreamSubscriberImpl) {
            c = this.onFailure;
        }
        try {
            if (c != null) {
                c.accept(failure);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onComplete() {
        Runnable completionCallback;
        if (this.done.getAndSet(true)) {
            return;
        }
        WriteStreamSubscriberImpl writeStreamSubscriberImpl = this;
        synchronized (writeStreamSubscriberImpl) {
            completionCallback = this.onCompletion;
        }
        try {
            this.stream.end();
            if (completionCallback != null) {
                completionCallback.run();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestMore() {
        Subscription s = this.upstream.get();
        if (s == null) {
            return;
        }
        WriteStreamSubscriberImpl writeStreamSubscriberImpl = this;
        synchronized (writeStreamSubscriberImpl) {
            if (this.done.get() || this.outstanding > 0) {
                return;
            }
            this.outstanding = 16;
        }
        s.request(16L);
    }

    @Override
    public synchronized WriteStreamSubscriber<I> onFailure(Consumer<? super Throwable> handler) {
        this.onFailure = handler;
        return this;
    }

    @Override
    public synchronized WriteStreamSubscriber<I> onComplete(Runnable handler) {
        this.onCompletion = handler;
        return this;
    }

    @Override
    public synchronized WriteStreamSubscriber<I> onWriteStreamError(Consumer<? super Throwable> handler) {
        this.onStreamFailure = handler;
        return this;
    }
}

