/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.rabbitmq;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MultiHelper;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Handler;
import io.vertx.mutiny.core.streams.Pipe;
import io.vertx.mutiny.core.streams.ReadStream;
import io.vertx.mutiny.core.streams.WriteStream;
import io.vertx.mutiny.rabbitmq.RabbitMQMessage;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

@MutinyGen(value=io.vertx.rabbitmq.RabbitMQConsumer.class)
public class RabbitMQConsumer
implements ReadStream<RabbitMQMessage> {
    public static final TypeArg<RabbitMQConsumer> __TYPE_ARG = new TypeArg(obj -> new RabbitMQConsumer((io.vertx.rabbitmq.RabbitMQConsumer)obj), RabbitMQConsumer::getDelegate);
    private final io.vertx.rabbitmq.RabbitMQConsumer delegate;
    static final TypeArg<RabbitMQMessage> TYPE_ARG_0 = new TypeArg(o1 -> RabbitMQMessage.newInstance((io.vertx.rabbitmq.RabbitMQMessage)o1), o1 -> o1.getDelegate());
    private Multi<RabbitMQMessage> multi;

    public RabbitMQConsumer(io.vertx.rabbitmq.RabbitMQConsumer delegate) {
        this.delegate = delegate;
    }

    public RabbitMQConsumer(Object delegate) {
        this.delegate = (io.vertx.rabbitmq.RabbitMQConsumer)delegate;
    }

    RabbitMQConsumer() {
        this.delegate = null;
    }

    public io.vertx.rabbitmq.RabbitMQConsumer getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RabbitMQConsumer that = (RabbitMQConsumer)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public Pipe<RabbitMQMessage> pipe() {
        Pipe ret = Pipe.newInstance((io.vertx.core.streams.Pipe)this.delegate.pipe(), TYPE_ARG_0);
        return ret;
    }

    @CheckReturnValue
    public Uni<Void> pipeTo(WriteStream<RabbitMQMessage> dst) {
        return AsyncResultUni.toUni(handler -> this.delegate.pipeTo(dst.getDelegate(), handler));
    }

    public Void pipeToAndAwait(WriteStream<RabbitMQMessage> dst) {
        return (Void)this.pipeTo(dst).await().indefinitely();
    }

    public void pipeToAndForget(WriteStream<RabbitMQMessage> dst) {
        this.pipeTo(dst).subscribe().with(UniHelper.NOOP);
    }

    @Fluent
    private RabbitMQConsumer __exceptionHandler(Handler<Throwable> exceptionHandler) {
        this.delegate.exceptionHandler(exceptionHandler);
        return this;
    }

    public RabbitMQConsumer exceptionHandler(Consumer<Throwable> exceptionHandler) {
        return this.__exceptionHandler(exceptionHandler != null ? exceptionHandler::accept : null);
    }

    @Fluent
    private RabbitMQConsumer __handler(final Handler<RabbitMQMessage> messageArrived) {
        this.delegate.handler((Handler)new Handler<io.vertx.rabbitmq.RabbitMQMessage>(){

            public void handle(io.vertx.rabbitmq.RabbitMQMessage event) {
                messageArrived.handle((Object)RabbitMQMessage.newInstance(event));
            }
        });
        return this;
    }

    public RabbitMQConsumer handler(Consumer<RabbitMQMessage> messageArrived) {
        return this.__handler(messageArrived != null ? messageArrived::accept : null);
    }

    @Fluent
    public RabbitMQConsumer pause() {
        this.delegate.pause();
        return this;
    }

    @Fluent
    public RabbitMQConsumer resume() {
        this.delegate.resume();
        return this;
    }

    @Fluent
    private RabbitMQConsumer __endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public RabbitMQConsumer endHandler(Runnable endHandler) {
        return this.__endHandler((Handler<Void>)((Handler)ignored -> endHandler.run()));
    }

    public String queueName() {
        String ret = this.delegate.queueName();
        return ret;
    }

    @Fluent
    public RabbitMQConsumer setQueueName(String name) {
        this.delegate.setQueueName(name);
        return this;
    }

    public String consumerTag() {
        String ret = this.delegate.consumerTag();
        return ret;
    }

    @CheckReturnValue
    public Uni<Void> cancel() {
        return AsyncResultUni.toUni(cancelResult -> this.delegate.cancel(cancelResult));
    }

    public Void cancelAndAwait() {
        return (Void)this.cancel().await().indefinitely();
    }

    public void cancelAndForget() {
        this.cancel().subscribe().with(UniHelper.NOOP);
    }

    public boolean isCancelled() {
        boolean ret = this.delegate.isCancelled();
        return ret;
    }

    public boolean isPaused() {
        boolean ret = this.delegate.isPaused();
        return ret;
    }

    @Fluent
    public RabbitMQConsumer fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    @CheckReturnValue
    public synchronized Multi<RabbitMQMessage> toMulti() {
        if (this.multi == null) {
            Function<io.vertx.rabbitmq.RabbitMQMessage, RabbitMQMessage> conv = RabbitMQMessage::newInstance;
            this.multi = MultiHelper.toMulti((io.vertx.core.streams.ReadStream)this.delegate, conv);
        }
        return this.multi;
    }

    public Iterable<RabbitMQMessage> toBlockingIterable() {
        return this.toMulti().subscribe().asIterable();
    }

    public Stream<RabbitMQMessage> toBlockingStream() {
        return this.toMulti().subscribe().asStream();
    }

    public static RabbitMQConsumer newInstance(io.vertx.rabbitmq.RabbitMQConsumer arg) {
        return arg != null ? new RabbitMQConsumer(arg) : null;
    }
}

