package io.vertx.mutiny.pgclient;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.function.Supplier;
import io.vertx.core.Future;
import java.util.function.Function;
import io.vertx.sqlclient.PoolOptions;
import java.util.List;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.core.Handler;

/**
 * A  of {@link io.vertx.mutiny.pgclient.PgConnection PostgreSQL connections}.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.pgclient.PgPool original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.pgclient.PgPool.class)
@Deprecated
public class PgPool extends io.vertx.mutiny.sqlclient.Pool implements io.smallrye.mutiny.vertx.MutinyDelegate {

  public static final io.smallrye.mutiny.vertx.TypeArg<PgPool> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new PgPool((io.vertx.pgclient.PgPool) obj),
    PgPool::getDelegate
  );

  private final io.vertx.pgclient.PgPool delegate;
  
  public PgPool(io.vertx.pgclient.PgPool delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public PgPool(Object delegate) {
    super((io.vertx.pgclient.PgPool)delegate);
    this.delegate = (io.vertx.pgclient.PgPool)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  PgPool() {
    super(null);
    this.delegate = null;
  }

  @Override
  public io.vertx.pgclient.PgPool getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PgPool that = (PgPool) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return 
   */
  public static io.vertx.mutiny.pgclient.PgPool pool() { 
    io.vertx.mutiny.pgclient.PgPool ret = io.vertx.mutiny.pgclient.PgPool.newInstance((io.vertx.pgclient.PgPool)io.vertx.pgclient.PgPool.pool());
    return ret;
  }

  /**
   * @param options 
   * @return 
   */
  public static io.vertx.mutiny.pgclient.PgPool pool(io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.pgclient.PgPool ret = io.vertx.mutiny.pgclient.PgPool.newInstance((io.vertx.pgclient.PgPool)io.vertx.pgclient.PgPool.pool(options));
    return ret;
  }

  /**
   * @param connectionUri 
   * @return 
   */
  public static io.vertx.mutiny.pgclient.PgPool pool(String connectionUri) { 
    io.vertx.mutiny.pgclient.PgPool ret = io.vertx.mutiny.pgclient.PgPool.newInstance((io.vertx.pgclient.PgPool)io.vertx.pgclient.PgPool.pool(connectionUri));
    return ret;
  }

  /**
   * @param connectionUri 
   * @param options 
   * @return 
   */
  public static io.vertx.mutiny.pgclient.PgPool pool(String connectionUri, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.pgclient.PgPool ret = io.vertx.mutiny.pgclient.PgPool.newInstance((io.vertx.pgclient.PgPool)io.vertx.pgclient.PgPool.pool(connectionUri, options));
    return ret;
  }

  /**
   * @param vertx 
   * @param connectionUri 
   * @return 
   */
  public static io.vertx.mutiny.pgclient.PgPool pool(io.vertx.mutiny.core.Vertx vertx, String connectionUri) { 
    io.vertx.mutiny.pgclient.PgPool ret = io.vertx.mutiny.pgclient.PgPool.newInstance((io.vertx.pgclient.PgPool)io.vertx.pgclient.PgPool.pool(vertx.getDelegate(), connectionUri));
    return ret;
  }

  /**
   * @param vertx 
   * @param options 
   * @return 
   */
  public static io.vertx.mutiny.pgclient.PgPool pool(io.vertx.mutiny.core.Vertx vertx, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.pgclient.PgPool ret = io.vertx.mutiny.pgclient.PgPool.newInstance((io.vertx.pgclient.PgPool)io.vertx.pgclient.PgPool.pool(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * @param vertx 
   * @param connectionUri 
   * @param poolOptions 
   * @return 
   */
  public static io.vertx.mutiny.pgclient.PgPool pool(io.vertx.mutiny.core.Vertx vertx, String connectionUri, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.mutiny.pgclient.PgPool ret = io.vertx.mutiny.pgclient.PgPool.newInstance((io.vertx.pgclient.PgPool)io.vertx.pgclient.PgPool.pool(vertx.getDelegate(), connectionUri, poolOptions));
    return ret;
  }

  /**
   * @param database the database
   * @param options the options for creating the pool
   * @return the connection pool
   */
  public static io.vertx.mutiny.pgclient.PgPool pool(io.vertx.pgclient.PgConnectOptions database, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.pgclient.PgPool ret = io.vertx.mutiny.pgclient.PgPool.newInstance((io.vertx.pgclient.PgPool)io.vertx.pgclient.PgPool.pool(database, options));
    return ret;
  }

  /**
   * @param vertx 
   * @param database 
   * @param options 
   * @return 
   */
  public static io.vertx.mutiny.pgclient.PgPool pool(io.vertx.mutiny.core.Vertx vertx, io.vertx.pgclient.PgConnectOptions database, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.pgclient.PgPool ret = io.vertx.mutiny.pgclient.PgPool.newInstance((io.vertx.pgclient.PgPool)io.vertx.pgclient.PgPool.pool(vertx.getDelegate(), database, options));
    return ret;
  }

  /**
   * @param databases the list of databases
   * @param poolOptions the options for creating the pool
   * @return the connection pool
   */
  public static io.vertx.mutiny.pgclient.PgPool pool(List<io.vertx.pgclient.PgConnectOptions> databases, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.mutiny.pgclient.PgPool ret = io.vertx.mutiny.pgclient.PgPool.newInstance((io.vertx.pgclient.PgPool)io.vertx.pgclient.PgPool.pool(databases, poolOptions));
    return ret;
  }

  /**
   * @param vertx 
   * @param databases 
   * @param poolOptions 
   * @return 
   */
  public static io.vertx.mutiny.pgclient.PgPool pool(io.vertx.mutiny.core.Vertx vertx, List<io.vertx.pgclient.PgConnectOptions> databases, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.mutiny.pgclient.PgPool ret = io.vertx.mutiny.pgclient.PgPool.newInstance((io.vertx.pgclient.PgPool)io.vertx.pgclient.PgPool.pool(vertx.getDelegate(), databases, poolOptions));
    return ret;
  }

  /**
   * @return 
   */
  public static io.vertx.mutiny.sqlclient.SqlClient client() { 
    io.vertx.mutiny.sqlclient.SqlClient ret = io.vertx.mutiny.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.pgclient.PgPool.client());
    return ret;
  }

  /**
   * @param options 
   * @return 
   */
  public static io.vertx.mutiny.sqlclient.SqlClient client(io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.sqlclient.SqlClient ret = io.vertx.mutiny.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.pgclient.PgPool.client(options));
    return ret;
  }

  /**
   * @param connectionUri 
   * @return 
   */
  public static io.vertx.mutiny.sqlclient.SqlClient client(String connectionUri) { 
    io.vertx.mutiny.sqlclient.SqlClient ret = io.vertx.mutiny.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.pgclient.PgPool.client(connectionUri));
    return ret;
  }

  /**
   * @param connectionUri 
   * @param options 
   * @return 
   */
  public static io.vertx.mutiny.sqlclient.SqlClient client(String connectionUri, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.sqlclient.SqlClient ret = io.vertx.mutiny.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.pgclient.PgPool.client(connectionUri, options));
    return ret;
  }

  /**
   * @param vertx 
   * @param connectionUri 
   * @return 
   */
  public static io.vertx.mutiny.sqlclient.SqlClient client(io.vertx.mutiny.core.Vertx vertx, String connectionUri) { 
    io.vertx.mutiny.sqlclient.SqlClient ret = io.vertx.mutiny.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.pgclient.PgPool.client(vertx.getDelegate(), connectionUri));
    return ret;
  }

  /**
   * @param vertx 
   * @param poolOptions 
   * @return 
   */
  public static io.vertx.mutiny.sqlclient.SqlClient client(io.vertx.mutiny.core.Vertx vertx, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.mutiny.sqlclient.SqlClient ret = io.vertx.mutiny.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.pgclient.PgPool.client(vertx.getDelegate(), poolOptions));
    return ret;
  }

  /**
   * @param vertx 
   * @param connectionUri 
   * @param options 
   * @return 
   */
  public static io.vertx.mutiny.sqlclient.SqlClient client(io.vertx.mutiny.core.Vertx vertx, String connectionUri, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.sqlclient.SqlClient ret = io.vertx.mutiny.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.pgclient.PgPool.client(vertx.getDelegate(), connectionUri, options));
    return ret;
  }

  /**
   * @param database 
   * @param options the options for creating the backing pool
   * @return the pooled client
   */
  public static io.vertx.mutiny.sqlclient.SqlClient client(io.vertx.pgclient.PgConnectOptions database, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.sqlclient.SqlClient ret = io.vertx.mutiny.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.pgclient.PgPool.client(database, options));
    return ret;
  }

  /**
   * @param vertx 
   * @param database 
   * @param options 
   * @return 
   */
  public static io.vertx.mutiny.sqlclient.SqlClient client(io.vertx.mutiny.core.Vertx vertx, io.vertx.pgclient.PgConnectOptions database, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.sqlclient.SqlClient ret = io.vertx.mutiny.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.pgclient.PgPool.client(vertx.getDelegate(), database, options));
    return ret;
  }

  /**
   * @param vertx 
   * @param databases 
   * @param options 
   * @return 
   */
  public static io.vertx.mutiny.sqlclient.SqlClient client(io.vertx.mutiny.core.Vertx vertx, List<io.vertx.pgclient.PgConnectOptions> databases, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.sqlclient.SqlClient ret = io.vertx.mutiny.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.pgclient.PgPool.client(vertx.getDelegate(), databases, options));
    return ret;
  }

  /**
   * @param databases the list of databases
   * @param options the options for creating the pool
   * @return the pooled client
   */
  public static io.vertx.mutiny.sqlclient.SqlClient client(List<io.vertx.pgclient.PgConnectOptions> databases, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.sqlclient.SqlClient ret = io.vertx.mutiny.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.pgclient.PgPool.client(databases, options));
    return ret;
  }

  @Fluent
  private io.vertx.mutiny.pgclient.PgPool __connectHandler(Handler<io.vertx.mutiny.sqlclient.SqlConnection> handler) { 
    delegate.connectHandler(io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, event -> io.vertx.mutiny.sqlclient.SqlConnection.newInstance((io.vertx.sqlclient.SqlConnection)event)));
    return this;
  }

  public io.vertx.mutiny.pgclient.PgPool connectHandler(java.util.function.Consumer<io.vertx.mutiny.sqlclient.SqlConnection> handler) {
    return __connectHandler(io.smallrye.mutiny.vertx.MutinyHelper.convertConsumer(handler));
  }

  @Fluent
  public io.vertx.mutiny.pgclient.PgPool connectionProvider(Function<io.vertx.mutiny.core.Context, io.smallrye.mutiny.Uni<io.vertx.mutiny.sqlclient.SqlConnection>> provider) { 
    delegate.connectionProvider(new java.util.function.Function<io.vertx.core.Context,io.vertx.core.Future<io.vertx.sqlclient.SqlConnection>>() {
      public io.vertx.core.Future<io.vertx.sqlclient.SqlConnection> apply(io.vertx.core.Context arg) {
            return io.smallrye.mutiny.vertx.UniHelper.toFuture(
                 provider.apply(io.vertx.mutiny.core.Context.newInstance((io.vertx.core.Context)arg)).map(x -> x.getDelegate())
            );
         }
     });
    return this;
  }

  /**
   * @param databases the databases supplier
   * @param poolOptions the options for creating the pool
   * @return the connection pool
   */
  public static io.vertx.mutiny.pgclient.PgPool pool(java.util.function.Supplier<io.smallrye.mutiny.Uni<io.vertx.pgclient.PgConnectOptions>> databases, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.mutiny.pgclient.PgPool ret = io.vertx.mutiny.pgclient.PgPool.newInstance((io.vertx.pgclient.PgPool)io.vertx.pgclient.PgPool.pool(() -> io.smallrye.mutiny.vertx.UniHelper.toFuture(databases.get()), poolOptions));
    return ret;
  }

  /**
   * @param vertx 
   * @param databases 
   * @param poolOptions 
   * @return 
   */
  public static io.vertx.mutiny.pgclient.PgPool pool(io.vertx.mutiny.core.Vertx vertx, java.util.function.Supplier<io.smallrye.mutiny.Uni<io.vertx.pgclient.PgConnectOptions>> databases, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.mutiny.pgclient.PgPool ret = io.vertx.mutiny.pgclient.PgPool.newInstance((io.vertx.pgclient.PgPool)io.vertx.pgclient.PgPool.pool(vertx.getDelegate(), () -> io.smallrye.mutiny.vertx.UniHelper.toFuture(databases.get()), poolOptions));
    return ret;
  }

  /**
   * @param vertx 
   * @param databases 
   * @param options 
   * @return 
   */
  public static io.vertx.mutiny.sqlclient.SqlClient client(io.vertx.mutiny.core.Vertx vertx, java.util.function.Supplier<io.smallrye.mutiny.Uni<io.vertx.pgclient.PgConnectOptions>> databases, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.sqlclient.SqlClient ret = io.vertx.mutiny.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.pgclient.PgPool.client(vertx.getDelegate(), () -> io.smallrye.mutiny.vertx.UniHelper.toFuture(databases.get()), options));
    return ret;
  }

  /**
   * @param databases the databases supplier
   * @param options the options for creating the pool
   * @return the pooled client
   */
  public static io.vertx.mutiny.sqlclient.SqlClient client(java.util.function.Supplier<io.smallrye.mutiny.Uni<io.vertx.pgclient.PgConnectOptions>> databases, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.sqlclient.SqlClient ret = io.vertx.mutiny.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.pgclient.PgPool.client(() -> io.smallrye.mutiny.vertx.UniHelper.toFuture(databases.get()), options));
    return ret;
  }

  public static  PgPool newInstance(io.vertx.pgclient.PgPool arg) {
    return arg != null ? new PgPool(arg) : null;
  }

}
