/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.ext.mongo;

import com.mongodb.client.model.changestream.ChangeStreamDocument;
import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.DelegatingHandler;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.AggregateOptions;
import io.vertx.ext.mongo.BulkOperation;
import io.vertx.ext.mongo.BulkWriteOptions;
import io.vertx.ext.mongo.CountOptions;
import io.vertx.ext.mongo.CreateCollectionOptions;
import io.vertx.ext.mongo.DistinctOptions;
import io.vertx.ext.mongo.FindOptions;
import io.vertx.ext.mongo.IndexModel;
import io.vertx.ext.mongo.IndexOptions;
import io.vertx.ext.mongo.MongoClientBulkWriteResult;
import io.vertx.ext.mongo.MongoClientDeleteResult;
import io.vertx.ext.mongo.MongoClientUpdateResult;
import io.vertx.ext.mongo.UpdateOptions;
import io.vertx.ext.mongo.WriteOption;
import io.vertx.mutiny.core.streams.ReadStream;
import io.vertx.mutiny.ext.mongo.MongoGridFsClient;
import java.util.List;

@MutinyGen(value=io.vertx.ext.mongo.MongoClient.class)
public class MongoClient {
    public static final TypeArg<MongoClient> __TYPE_ARG = new TypeArg(obj -> new MongoClient((io.vertx.ext.mongo.MongoClient)obj), MongoClient::getDelegate);
    private final io.vertx.ext.mongo.MongoClient delegate;
    public static final String DEFAULT_POOL_NAME = "DEFAULT_POOL";
    public static final String DEFAULT_DB_NAME = "DEFAULT_DB";

    public MongoClient(io.vertx.ext.mongo.MongoClient delegate) {
        this.delegate = delegate;
    }

    public MongoClient(Object delegate) {
        this.delegate = (io.vertx.ext.mongo.MongoClient)delegate;
    }

    MongoClient() {
        this.delegate = null;
    }

    public io.vertx.ext.mongo.MongoClient getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoClient that = (MongoClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public static MongoClient create(io.vertx.mutiny.core.Vertx vertx, JsonObject config) {
        MongoClient ret = MongoClient.newInstance(io.vertx.ext.mongo.MongoClient.create((Vertx)vertx.getDelegate(), (JsonObject)config));
        return ret;
    }

    public static MongoClient createShared(io.vertx.mutiny.core.Vertx vertx, JsonObject config, String dataSourceName) {
        MongoClient ret = MongoClient.newInstance(io.vertx.ext.mongo.MongoClient.createShared((Vertx)vertx.getDelegate(), (JsonObject)config, (String)dataSourceName));
        return ret;
    }

    public static MongoClient createShared(io.vertx.mutiny.core.Vertx vertx, JsonObject config) {
        MongoClient ret = MongoClient.newInstance(io.vertx.ext.mongo.MongoClient.createShared((Vertx)vertx.getDelegate(), (JsonObject)config));
        return ret;
    }

    @CheckReturnValue
    public Uni<String> save(String collection, JsonObject document) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.save(collection, document, resultHandler));
    }

    public String saveAndAwait(String collection, JsonObject document) {
        return (String)this.save(collection, document).await().indefinitely();
    }

    @Fluent
    public MongoClient saveAndForget(String collection, JsonObject document) {
        this.save(collection, document).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<String> saveWithOptions(String collection, JsonObject document, WriteOption writeOption) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.saveWithOptions(collection, document, writeOption, resultHandler));
    }

    public String saveWithOptionsAndAwait(String collection, JsonObject document, WriteOption writeOption) {
        return (String)this.saveWithOptions(collection, document, writeOption).await().indefinitely();
    }

    @Fluent
    public MongoClient saveWithOptionsAndForget(String collection, JsonObject document, WriteOption writeOption) {
        this.saveWithOptions(collection, document, writeOption).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<String> insert(String collection, JsonObject document) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.insert(collection, document, resultHandler));
    }

    public String insertAndAwait(String collection, JsonObject document) {
        return (String)this.insert(collection, document).await().indefinitely();
    }

    @Fluent
    public MongoClient insertAndForget(String collection, JsonObject document) {
        this.insert(collection, document).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<String> insertWithOptions(String collection, JsonObject document, WriteOption writeOption) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.insertWithOptions(collection, document, writeOption, resultHandler));
    }

    public String insertWithOptionsAndAwait(String collection, JsonObject document, WriteOption writeOption) {
        return (String)this.insertWithOptions(collection, document, writeOption).await().indefinitely();
    }

    @Fluent
    public MongoClient insertWithOptionsAndForget(String collection, JsonObject document, WriteOption writeOption) {
        this.insertWithOptions(collection, document, writeOption).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<MongoClientUpdateResult> updateCollection(String collection, JsonObject query, JsonObject update) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.updateCollection(collection, query, update, resultHandler));
    }

    public MongoClientUpdateResult updateCollectionAndAwait(String collection, JsonObject query, JsonObject update) {
        return (MongoClientUpdateResult)this.updateCollection(collection, query, update).await().indefinitely();
    }

    @Fluent
    public MongoClient updateCollectionAndForget(String collection, JsonObject query, JsonObject update) {
        this.updateCollection(collection, query, update).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<MongoClientUpdateResult> updateCollection(String collection, JsonObject query, JsonArray update) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.updateCollection(collection, query, update, resultHandler));
    }

    public MongoClientUpdateResult updateCollectionAndAwait(String collection, JsonObject query, JsonArray update) {
        return (MongoClientUpdateResult)this.updateCollection(collection, query, update).await().indefinitely();
    }

    @Fluent
    public MongoClient updateCollectionAndForget(String collection, JsonObject query, JsonArray update) {
        this.updateCollection(collection, query, update).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<MongoClientUpdateResult> updateCollectionWithOptions(String collection, JsonObject query, JsonObject update, UpdateOptions options) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.updateCollectionWithOptions(collection, query, update, options, resultHandler));
    }

    public MongoClientUpdateResult updateCollectionWithOptionsAndAwait(String collection, JsonObject query, JsonObject update, UpdateOptions options) {
        return (MongoClientUpdateResult)this.updateCollectionWithOptions(collection, query, update, options).await().indefinitely();
    }

    @Fluent
    public MongoClient updateCollectionWithOptionsAndForget(String collection, JsonObject query, JsonObject update, UpdateOptions options) {
        this.updateCollectionWithOptions(collection, query, update, options).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<MongoClientUpdateResult> updateCollectionWithOptions(String collection, JsonObject query, JsonArray update, UpdateOptions options) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.updateCollectionWithOptions(collection, query, update, options, resultHandler));
    }

    public MongoClientUpdateResult updateCollectionWithOptionsAndAwait(String collection, JsonObject query, JsonArray update, UpdateOptions options) {
        return (MongoClientUpdateResult)this.updateCollectionWithOptions(collection, query, update, options).await().indefinitely();
    }

    @Fluent
    public MongoClient updateCollectionWithOptionsAndForget(String collection, JsonObject query, JsonArray update, UpdateOptions options) {
        this.updateCollectionWithOptions(collection, query, update, options).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<MongoClientUpdateResult> replaceDocuments(String collection, JsonObject query, JsonObject replace) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.replaceDocuments(collection, query, replace, resultHandler));
    }

    public MongoClientUpdateResult replaceDocumentsAndAwait(String collection, JsonObject query, JsonObject replace) {
        return (MongoClientUpdateResult)this.replaceDocuments(collection, query, replace).await().indefinitely();
    }

    @Fluent
    public MongoClient replaceDocumentsAndForget(String collection, JsonObject query, JsonObject replace) {
        this.replaceDocuments(collection, query, replace).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<MongoClientUpdateResult> replaceDocumentsWithOptions(String collection, JsonObject query, JsonObject replace, UpdateOptions options) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.replaceDocumentsWithOptions(collection, query, replace, options, resultHandler));
    }

    public MongoClientUpdateResult replaceDocumentsWithOptionsAndAwait(String collection, JsonObject query, JsonObject replace, UpdateOptions options) {
        return (MongoClientUpdateResult)this.replaceDocumentsWithOptions(collection, query, replace, options).await().indefinitely();
    }

    @Fluent
    public MongoClient replaceDocumentsWithOptionsAndForget(String collection, JsonObject query, JsonObject replace, UpdateOptions options) {
        this.replaceDocumentsWithOptions(collection, query, replace, options).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<MongoClientBulkWriteResult> bulkWrite(String collection, List<BulkOperation> operations) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.bulkWrite(collection, operations, resultHandler));
    }

    public MongoClientBulkWriteResult bulkWriteAndAwait(String collection, List<BulkOperation> operations) {
        return (MongoClientBulkWriteResult)this.bulkWrite(collection, operations).await().indefinitely();
    }

    @Fluent
    public MongoClient bulkWriteAndForget(String collection, List<BulkOperation> operations) {
        this.bulkWrite(collection, operations).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<MongoClientBulkWriteResult> bulkWriteWithOptions(String collection, List<BulkOperation> operations, BulkWriteOptions bulkWriteOptions) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.bulkWriteWithOptions(collection, operations, bulkWriteOptions, resultHandler));
    }

    public MongoClientBulkWriteResult bulkWriteWithOptionsAndAwait(String collection, List<BulkOperation> operations, BulkWriteOptions bulkWriteOptions) {
        return (MongoClientBulkWriteResult)this.bulkWriteWithOptions(collection, operations, bulkWriteOptions).await().indefinitely();
    }

    @Fluent
    public MongoClient bulkWriteWithOptionsAndForget(String collection, List<BulkOperation> operations, BulkWriteOptions bulkWriteOptions) {
        this.bulkWriteWithOptions(collection, operations, bulkWriteOptions).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<List<JsonObject>> find(String collection, JsonObject query) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.find(collection, query, resultHandler));
    }

    public List<JsonObject> findAndAwait(String collection, JsonObject query) {
        return (List)this.find(collection, query).await().indefinitely();
    }

    @Fluent
    public MongoClient findAndForget(String collection, JsonObject query) {
        this.find(collection, query).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public ReadStream<JsonObject> findBatch(String collection, JsonObject query) {
        ReadStream ret = ReadStream.newInstance((io.vertx.core.streams.ReadStream)this.delegate.findBatch(collection, query), (TypeArg)TypeArg.unknown());
        return ret;
    }

    @CheckReturnValue
    public Uni<List<JsonObject>> findWithOptions(String collection, JsonObject query, FindOptions options) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.findWithOptions(collection, query, options, resultHandler));
    }

    public List<JsonObject> findWithOptionsAndAwait(String collection, JsonObject query, FindOptions options) {
        return (List)this.findWithOptions(collection, query, options).await().indefinitely();
    }

    @Fluent
    public MongoClient findWithOptionsAndForget(String collection, JsonObject query, FindOptions options) {
        this.findWithOptions(collection, query, options).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public ReadStream<JsonObject> findBatchWithOptions(String collection, JsonObject query, FindOptions options) {
        ReadStream ret = ReadStream.newInstance((io.vertx.core.streams.ReadStream)this.delegate.findBatchWithOptions(collection, query, options), (TypeArg)TypeArg.unknown());
        return ret;
    }

    @CheckReturnValue
    public Uni<JsonObject> findOne(String collection, JsonObject query, JsonObject fields) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.findOne(collection, query, fields, resultHandler));
    }

    public JsonObject findOneAndAwait(String collection, JsonObject query, JsonObject fields) {
        return (JsonObject)this.findOne(collection, query, fields).await().indefinitely();
    }

    @Fluent
    public MongoClient findOneAndForget(String collection, JsonObject query, JsonObject fields) {
        this.findOne(collection, query, fields).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<JsonObject> findOneAndUpdate(String collection, JsonObject query, JsonObject update) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.findOneAndUpdate(collection, query, update, resultHandler));
    }

    public JsonObject findOneAndUpdateAndAwait(String collection, JsonObject query, JsonObject update) {
        return (JsonObject)this.findOneAndUpdate(collection, query, update).await().indefinitely();
    }

    @Fluent
    public MongoClient findOneAndUpdateAndForget(String collection, JsonObject query, JsonObject update) {
        this.findOneAndUpdate(collection, query, update).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<JsonObject> findOneAndUpdateWithOptions(String collection, JsonObject query, JsonObject update, FindOptions findOptions, UpdateOptions updateOptions) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.findOneAndUpdateWithOptions(collection, query, update, findOptions, updateOptions, resultHandler));
    }

    public JsonObject findOneAndUpdateWithOptionsAndAwait(String collection, JsonObject query, JsonObject update, FindOptions findOptions, UpdateOptions updateOptions) {
        return (JsonObject)this.findOneAndUpdateWithOptions(collection, query, update, findOptions, updateOptions).await().indefinitely();
    }

    @Fluent
    public MongoClient findOneAndUpdateWithOptionsAndForget(String collection, JsonObject query, JsonObject update, FindOptions findOptions, UpdateOptions updateOptions) {
        this.findOneAndUpdateWithOptions(collection, query, update, findOptions, updateOptions).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<JsonObject> findOneAndReplace(String collection, JsonObject query, JsonObject replace) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.findOneAndReplace(collection, query, replace, resultHandler));
    }

    public JsonObject findOneAndReplaceAndAwait(String collection, JsonObject query, JsonObject replace) {
        return (JsonObject)this.findOneAndReplace(collection, query, replace).await().indefinitely();
    }

    @Fluent
    public MongoClient findOneAndReplaceAndForget(String collection, JsonObject query, JsonObject replace) {
        this.findOneAndReplace(collection, query, replace).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<JsonObject> findOneAndReplaceWithOptions(String collection, JsonObject query, JsonObject replace, FindOptions findOptions, UpdateOptions updateOptions) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.findOneAndReplaceWithOptions(collection, query, replace, findOptions, updateOptions, resultHandler));
    }

    public JsonObject findOneAndReplaceWithOptionsAndAwait(String collection, JsonObject query, JsonObject replace, FindOptions findOptions, UpdateOptions updateOptions) {
        return (JsonObject)this.findOneAndReplaceWithOptions(collection, query, replace, findOptions, updateOptions).await().indefinitely();
    }

    @Fluent
    public MongoClient findOneAndReplaceWithOptionsAndForget(String collection, JsonObject query, JsonObject replace, FindOptions findOptions, UpdateOptions updateOptions) {
        this.findOneAndReplaceWithOptions(collection, query, replace, findOptions, updateOptions).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<JsonObject> findOneAndDelete(String collection, JsonObject query) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.findOneAndDelete(collection, query, resultHandler));
    }

    public JsonObject findOneAndDeleteAndAwait(String collection, JsonObject query) {
        return (JsonObject)this.findOneAndDelete(collection, query).await().indefinitely();
    }

    @Fluent
    public MongoClient findOneAndDeleteAndForget(String collection, JsonObject query) {
        this.findOneAndDelete(collection, query).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<JsonObject> findOneAndDeleteWithOptions(String collection, JsonObject query, FindOptions findOptions) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.findOneAndDeleteWithOptions(collection, query, findOptions, resultHandler));
    }

    public JsonObject findOneAndDeleteWithOptionsAndAwait(String collection, JsonObject query, FindOptions findOptions) {
        return (JsonObject)this.findOneAndDeleteWithOptions(collection, query, findOptions).await().indefinitely();
    }

    @Fluent
    public MongoClient findOneAndDeleteWithOptionsAndForget(String collection, JsonObject query, FindOptions findOptions) {
        this.findOneAndDeleteWithOptions(collection, query, findOptions).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Long> count(String collection, JsonObject query) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.count(collection, query, resultHandler));
    }

    public Long countAndAwait(String collection, JsonObject query) {
        return (Long)this.count(collection, query).await().indefinitely();
    }

    @Fluent
    public MongoClient countAndForget(String collection, JsonObject query) {
        this.count(collection, query).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Long> countWithOptions(String collection, JsonObject query, CountOptions countOptions) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.countWithOptions(collection, query, countOptions, resultHandler));
    }

    public Long countWithOptionsAndAwait(String collection, JsonObject query, CountOptions countOptions) {
        return (Long)this.countWithOptions(collection, query, countOptions).await().indefinitely();
    }

    @Fluent
    public MongoClient countWithOptionsAndForget(String collection, JsonObject query, CountOptions countOptions) {
        this.countWithOptions(collection, query, countOptions).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<MongoClientDeleteResult> removeDocuments(String collection, JsonObject query) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.removeDocuments(collection, query, resultHandler));
    }

    public MongoClientDeleteResult removeDocumentsAndAwait(String collection, JsonObject query) {
        return (MongoClientDeleteResult)this.removeDocuments(collection, query).await().indefinitely();
    }

    @Fluent
    public MongoClient removeDocumentsAndForget(String collection, JsonObject query) {
        this.removeDocuments(collection, query).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<MongoClientDeleteResult> removeDocumentsWithOptions(String collection, JsonObject query, WriteOption writeOption) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.removeDocumentsWithOptions(collection, query, writeOption, resultHandler));
    }

    public MongoClientDeleteResult removeDocumentsWithOptionsAndAwait(String collection, JsonObject query, WriteOption writeOption) {
        return (MongoClientDeleteResult)this.removeDocumentsWithOptions(collection, query, writeOption).await().indefinitely();
    }

    @Fluent
    public MongoClient removeDocumentsWithOptionsAndForget(String collection, JsonObject query, WriteOption writeOption) {
        this.removeDocumentsWithOptions(collection, query, writeOption).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<MongoClientDeleteResult> removeDocument(String collection, JsonObject query) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.removeDocument(collection, query, resultHandler));
    }

    public MongoClientDeleteResult removeDocumentAndAwait(String collection, JsonObject query) {
        return (MongoClientDeleteResult)this.removeDocument(collection, query).await().indefinitely();
    }

    @Fluent
    public MongoClient removeDocumentAndForget(String collection, JsonObject query) {
        this.removeDocument(collection, query).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<MongoClientDeleteResult> removeDocumentWithOptions(String collection, JsonObject query, WriteOption writeOption) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.removeDocumentWithOptions(collection, query, writeOption, resultHandler));
    }

    public MongoClientDeleteResult removeDocumentWithOptionsAndAwait(String collection, JsonObject query, WriteOption writeOption) {
        return (MongoClientDeleteResult)this.removeDocumentWithOptions(collection, query, writeOption).await().indefinitely();
    }

    @Fluent
    public MongoClient removeDocumentWithOptionsAndForget(String collection, JsonObject query, WriteOption writeOption) {
        this.removeDocumentWithOptions(collection, query, writeOption).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> createCollection(String collectionName) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.createCollection(collectionName, resultHandler));
    }

    public Void createCollectionAndAwait(String collectionName) {
        return (Void)this.createCollection(collectionName).await().indefinitely();
    }

    @Fluent
    public MongoClient createCollectionAndForget(String collectionName) {
        this.createCollection(collectionName).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> createCollectionWithOptions(String collectionName, CreateCollectionOptions collectionOptions) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.createCollectionWithOptions(collectionName, collectionOptions, resultHandler));
    }

    public Void createCollectionWithOptionsAndAwait(String collectionName, CreateCollectionOptions collectionOptions) {
        return (Void)this.createCollectionWithOptions(collectionName, collectionOptions).await().indefinitely();
    }

    @Fluent
    public MongoClient createCollectionWithOptionsAndForget(String collectionName, CreateCollectionOptions collectionOptions) {
        this.createCollectionWithOptions(collectionName, collectionOptions).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<List<String>> getCollections() {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.getCollections(resultHandler));
    }

    public List<String> getCollectionsAndAwait() {
        return (List)this.getCollections().await().indefinitely();
    }

    @Fluent
    public MongoClient getCollectionsAndForget() {
        this.getCollections().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> dropCollection(String collection) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.dropCollection(collection, resultHandler));
    }

    public Void dropCollectionAndAwait(String collection) {
        return (Void)this.dropCollection(collection).await().indefinitely();
    }

    @Fluent
    public MongoClient dropCollectionAndForget(String collection) {
        this.dropCollection(collection).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> createIndex(String collection, JsonObject key) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.createIndex(collection, key, resultHandler));
    }

    public Void createIndexAndAwait(String collection, JsonObject key) {
        return (Void)this.createIndex(collection, key).await().indefinitely();
    }

    @Fluent
    public MongoClient createIndexAndForget(String collection, JsonObject key) {
        this.createIndex(collection, key).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> createIndexWithOptions(String collection, JsonObject key, IndexOptions options) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.createIndexWithOptions(collection, key, options, resultHandler));
    }

    public Void createIndexWithOptionsAndAwait(String collection, JsonObject key, IndexOptions options) {
        return (Void)this.createIndexWithOptions(collection, key, options).await().indefinitely();
    }

    @Fluent
    public MongoClient createIndexWithOptionsAndForget(String collection, JsonObject key, IndexOptions options) {
        this.createIndexWithOptions(collection, key, options).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> createIndexes(String collection, List<IndexModel> indexes) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.createIndexes(collection, indexes, resultHandler));
    }

    public Void createIndexesAndAwait(String collection, List<IndexModel> indexes) {
        return (Void)this.createIndexes(collection, indexes).await().indefinitely();
    }

    @Fluent
    public MongoClient createIndexesAndForget(String collection, List<IndexModel> indexes) {
        this.createIndexes(collection, indexes).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<JsonArray> listIndexes(String collection) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.listIndexes(collection, resultHandler));
    }

    public JsonArray listIndexesAndAwait(String collection) {
        return (JsonArray)this.listIndexes(collection).await().indefinitely();
    }

    @Fluent
    public MongoClient listIndexesAndForget(String collection) {
        this.listIndexes(collection).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> dropIndex(String collection, String indexName) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.dropIndex(collection, indexName, resultHandler));
    }

    public Void dropIndexAndAwait(String collection, String indexName) {
        return (Void)this.dropIndex(collection, indexName).await().indefinitely();
    }

    @Fluent
    public MongoClient dropIndexAndForget(String collection, String indexName) {
        this.dropIndex(collection, indexName).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<JsonObject> runCommand(String commandName, JsonObject command) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.runCommand(commandName, command, resultHandler));
    }

    public JsonObject runCommandAndAwait(String commandName, JsonObject command) {
        return (JsonObject)this.runCommand(commandName, command).await().indefinitely();
    }

    @Fluent
    public MongoClient runCommandAndForget(String commandName, JsonObject command) {
        this.runCommand(commandName, command).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<JsonArray> distinct(String collection, String fieldName, String resultClassname) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.distinct(collection, fieldName, resultClassname, resultHandler));
    }

    public JsonArray distinctAndAwait(String collection, String fieldName, String resultClassname) {
        return (JsonArray)this.distinct(collection, fieldName, resultClassname).await().indefinitely();
    }

    @Fluent
    public MongoClient distinctAndForget(String collection, String fieldName, String resultClassname) {
        this.distinct(collection, fieldName, resultClassname).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<JsonArray> distinct(String collection, String fieldName, String resultClassname, DistinctOptions distinctOptions) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.distinct(collection, fieldName, resultClassname, distinctOptions, resultHandler));
    }

    public JsonArray distinctAndAwait(String collection, String fieldName, String resultClassname, DistinctOptions distinctOptions) {
        return (JsonArray)this.distinct(collection, fieldName, resultClassname, distinctOptions).await().indefinitely();
    }

    @Fluent
    public MongoClient distinctAndForget(String collection, String fieldName, String resultClassname, DistinctOptions distinctOptions) {
        this.distinct(collection, fieldName, resultClassname, distinctOptions).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<JsonArray> distinctWithQuery(String collection, String fieldName, String resultClassname, JsonObject query) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.distinctWithQuery(collection, fieldName, resultClassname, query, resultHandler));
    }

    public JsonArray distinctWithQueryAndAwait(String collection, String fieldName, String resultClassname, JsonObject query) {
        return (JsonArray)this.distinctWithQuery(collection, fieldName, resultClassname, query).await().indefinitely();
    }

    @Fluent
    public MongoClient distinctWithQueryAndForget(String collection, String fieldName, String resultClassname, JsonObject query) {
        this.distinctWithQuery(collection, fieldName, resultClassname, query).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<JsonArray> distinctWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, DistinctOptions distinctOptions) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.distinctWithQuery(collection, fieldName, resultClassname, query, distinctOptions, resultHandler));
    }

    public JsonArray distinctWithQueryAndAwait(String collection, String fieldName, String resultClassname, JsonObject query, DistinctOptions distinctOptions) {
        return (JsonArray)this.distinctWithQuery(collection, fieldName, resultClassname, query, distinctOptions).await().indefinitely();
    }

    @Fluent
    public MongoClient distinctWithQueryAndForget(String collection, String fieldName, String resultClassname, JsonObject query, DistinctOptions distinctOptions) {
        this.distinctWithQuery(collection, fieldName, resultClassname, query, distinctOptions).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public ReadStream<JsonObject> distinctBatch(String collection, String fieldName, String resultClassname) {
        ReadStream ret = ReadStream.newInstance((io.vertx.core.streams.ReadStream)this.delegate.distinctBatch(collection, fieldName, resultClassname), (TypeArg)TypeArg.unknown());
        return ret;
    }

    public ReadStream<JsonObject> distinctBatch(String collection, String fieldName, String resultClassname, DistinctOptions distinctOptions) {
        ReadStream ret = ReadStream.newInstance((io.vertx.core.streams.ReadStream)this.delegate.distinctBatch(collection, fieldName, resultClassname, distinctOptions), (TypeArg)TypeArg.unknown());
        return ret;
    }

    public ReadStream<JsonObject> distinctBatchWithQuery(String collection, String fieldName, String resultClassname, JsonObject query) {
        ReadStream ret = ReadStream.newInstance((io.vertx.core.streams.ReadStream)this.delegate.distinctBatchWithQuery(collection, fieldName, resultClassname, query), (TypeArg)TypeArg.unknown());
        return ret;
    }

    public ReadStream<JsonObject> distinctBatchWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, DistinctOptions distinctOptions) {
        ReadStream ret = ReadStream.newInstance((io.vertx.core.streams.ReadStream)this.delegate.distinctBatchWithQuery(collection, fieldName, resultClassname, query, distinctOptions), (TypeArg)TypeArg.unknown());
        return ret;
    }

    public ReadStream<JsonObject> distinctBatchWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, int batchSize) {
        ReadStream ret = ReadStream.newInstance((io.vertx.core.streams.ReadStream)this.delegate.distinctBatchWithQuery(collection, fieldName, resultClassname, query, batchSize), (TypeArg)TypeArg.unknown());
        return ret;
    }

    public ReadStream<JsonObject> distinctBatchWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, int batchSize, DistinctOptions distinctOptions) {
        ReadStream ret = ReadStream.newInstance((io.vertx.core.streams.ReadStream)this.delegate.distinctBatchWithQuery(collection, fieldName, resultClassname, query, batchSize, distinctOptions), (TypeArg)TypeArg.unknown());
        return ret;
    }

    public ReadStream<JsonObject> aggregate(String collection, JsonArray pipeline) {
        ReadStream ret = ReadStream.newInstance((io.vertx.core.streams.ReadStream)this.delegate.aggregate(collection, pipeline), (TypeArg)TypeArg.unknown());
        return ret;
    }

    public ReadStream<JsonObject> aggregateWithOptions(String collection, JsonArray pipeline, AggregateOptions options) {
        ReadStream ret = ReadStream.newInstance((io.vertx.core.streams.ReadStream)this.delegate.aggregateWithOptions(collection, pipeline, options), (TypeArg)TypeArg.unknown());
        return ret;
    }

    @CheckReturnValue
    public Uni<MongoGridFsClient> createDefaultGridFsBucketService() {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.createDefaultGridFsBucketService((Handler)new DelegatingHandler(resultHandler, ar -> ar.map(event -> MongoGridFsClient.newInstance(event)))));
    }

    public MongoGridFsClient createDefaultGridFsBucketServiceAndAwait() {
        return (MongoGridFsClient)this.createDefaultGridFsBucketService().await().indefinitely();
    }

    @Fluent
    public MongoClient createDefaultGridFsBucketServiceAndForget() {
        this.createDefaultGridFsBucketService().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<MongoGridFsClient> createGridFsBucketService(String bucketName) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.createGridFsBucketService(bucketName, (Handler)new DelegatingHandler(resultHandler, ar -> ar.map(event -> MongoGridFsClient.newInstance(event)))));
    }

    public MongoGridFsClient createGridFsBucketServiceAndAwait(String bucketName) {
        return (MongoGridFsClient)this.createGridFsBucketService(bucketName).await().indefinitely();
    }

    @Fluent
    public MongoClient createGridFsBucketServiceAndForget(String bucketName) {
        this.createGridFsBucketService(bucketName).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> close() {
        return AsyncResultUni.toUni(handler -> this.delegate.close(handler));
    }

    public Void closeAndAwait() {
        return (Void)this.close().await().indefinitely();
    }

    public void closeAndForget() {
        this.close().subscribe().with(UniHelper.NOOP);
    }

    public ReadStream<ChangeStreamDocument<JsonObject>> watch(String collection, JsonArray pipeline, boolean withUpdatedDoc, int batchSize) {
        ReadStream ret = ReadStream.newInstance((io.vertx.core.streams.ReadStream)this.delegate.watch(collection, pipeline, withUpdatedDoc, batchSize), (TypeArg)TypeArg.unknown());
        return ret;
    }

    public static MongoClient newInstance(io.vertx.ext.mongo.MongoClient arg) {
        return arg != null ? new MongoClient(arg) : null;
    }
}

