package io.vertx.mutiny.ext.mail;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.ext.mail.MailConfig;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;
import io.vertx.ext.mail.MailMessage;
import io.vertx.ext.mail.MailResult;

/**
 * SMTP mail client for Vert.x
 * <p>
 * A simple asynchronous API for sending mails from Vert.x applications
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.mail.MailClient original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.mail.MailClient.class)
public class MailClient implements io.smallrye.mutiny.vertx.MutinyDelegate {

  public static final io.smallrye.mutiny.vertx.TypeArg<MailClient> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new MailClient((io.vertx.ext.mail.MailClient) obj),
    MailClient::getDelegate
  );

  private final io.vertx.ext.mail.MailClient delegate;
  
  public MailClient(io.vertx.ext.mail.MailClient delegate) {
    this.delegate = delegate;
  }

  public MailClient(Object delegate) {
    this.delegate = (io.vertx.ext.mail.MailClient)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  MailClient() {
    this.delegate = null;
  }

  @Override
  public io.vertx.ext.mail.MailClient getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MailClient that = (MailClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param vertx the Vertx instance the operation will be run in
   * @param config MailConfig configuration to be used for sending mails
   * @return MailClient instance that can then be used to send multiple mails
   */
  public static io.vertx.mutiny.ext.mail.MailClient create(io.vertx.mutiny.core.Vertx vertx, io.vertx.ext.mail.MailConfig config) { 
    io.vertx.mutiny.ext.mail.MailClient ret = io.vertx.mutiny.ext.mail.MailClient.newInstance((io.vertx.ext.mail.MailClient)io.vertx.ext.mail.MailClient.create(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * @param vertx the Vert.x instance
   * @param config the configuration
   * @param poolName the pool name
   * @return the client
   */
  public static io.vertx.mutiny.ext.mail.MailClient createShared(io.vertx.mutiny.core.Vertx vertx, io.vertx.ext.mail.MailConfig config, String poolName) { 
    io.vertx.mutiny.ext.mail.MailClient ret = io.vertx.mutiny.ext.mail.MailClient.newInstance((io.vertx.ext.mail.MailClient)io.vertx.ext.mail.MailClient.createShared(vertx.getDelegate(), config, poolName));
    return ret;
  }

  /**
   * @param vertx the Vert.x instance
   * @param config the configuration
   * @return the client
   */
  public static io.vertx.mutiny.ext.mail.MailClient createShared(io.vertx.mutiny.core.Vertx vertx, io.vertx.ext.mail.MailConfig config) { 
    io.vertx.mutiny.ext.mail.MailClient ret = io.vertx.mutiny.ext.mail.MailClient.newInstance((io.vertx.ext.mail.MailClient)io.vertx.ext.mail.MailClient.createShared(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * send a single mail via MailClient
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param email MailMessage object containing the mail text, from/to, attachments etc
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.ext.mail.MailResult> sendMail(io.vertx.ext.mail.MailMessage email) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.sendMail(email, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mail.MailClient#sendMail(MailMessage)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param email MailMessage object containing the mail text, from/to, attachments etc
   * @return the MailResult instance produced by the operation.
   */
  public io.vertx.ext.mail.MailResult sendMailAndAwait(io.vertx.ext.mail.MailMessage email) { 
    return (io.vertx.ext.mail.MailResult) sendMail(email).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mail.MailClient#sendMail(MailMessage)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mail.MailClient#sendMail(MailMessage)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mail.MailClient#sendMail(MailMessage)} but you don't need to compose it with other operations.
   * @param email MailMessage object containing the mail text, from/to, attachments etc
   * @return the instance of MailClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.ext.mail.MailClient sendMailAndForget(io.vertx.ext.mail.MailMessage email) { 
    sendMail(email).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Close the MailClient
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(closedHandler -> {
        delegate.close(closedHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.mail.MailClient#close}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.mail.MailClient#close} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.mail.MailClient#close}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.mail.MailClient#close} but you don't need to compose it with other operations.
   */
  public void closeAndForget() { 
    close().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * The name of the default pool
   */
  public static final String DEFAULT_POOL_NAME = io.vertx.ext.mail.MailClient.DEFAULT_POOL_NAME;
  public static  MailClient newInstance(io.vertx.ext.mail.MailClient arg) {
    return arg != null ? new MailClient(arg) : null;
  }

}
