/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.httpproxy;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.core.Future;
import io.vertx.mutiny.httpproxy.ProxyContext;
import io.vertx.mutiny.httpproxy.ProxyInterceptor;
import io.vertx.mutiny.httpproxy.ProxyResponse;

class ProxyInterceptorImpl
implements ProxyInterceptor {
    private final io.vertx.httpproxy.ProxyInterceptor delegate;

    @Override
    public io.vertx.httpproxy.ProxyInterceptor getDelegate() {
        return this.delegate;
    }

    ProxyInterceptorImpl() {
        this.delegate = null;
    }

    public ProxyInterceptorImpl(io.vertx.httpproxy.ProxyInterceptor delegate) {
        this.delegate = delegate;
    }

    @Override
    @CheckReturnValue
    public Uni<ProxyResponse> handleProxyRequest(ProxyContext context) {
        return UniHelper.toUni((Future)this.delegate.handleProxyRequest(context.getDelegate()).map(x -> ProxyResponse.newInstance(x)));
    }

    public ProxyResponse handleProxyRequestAndAwait(ProxyContext context) {
        return (ProxyResponse)this.handleProxyRequest(context).await().indefinitely();
    }

    public void handleProxyRequestAndForget(ProxyContext context) {
        this.handleProxyRequest(context).subscribe().with(UniHelper.NOOP);
    }

    @Override
    @CheckReturnValue
    public Uni<Void> handleProxyResponse(ProxyContext context) {
        return UniHelper.toUni((Future)this.delegate.handleProxyResponse(context.getDelegate()));
    }

    public Void handleProxyResponseAndAwait(ProxyContext context) {
        return (Void)this.handleProxyResponse(context).await().indefinitely();
    }

    public void handleProxyResponseAndForget(ProxyContext context) {
        this.handleProxyResponse(context).subscribe().with(UniHelper.NOOP);
    }
}

