/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.core.http;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyDelegate;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.MutinyHelper;
import io.smallrye.mutiny.vertx.ReadStreamSubscriber;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.smallrye.mutiny.vertx.WriteStreamSubscriber;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.streams.WriteStream;
import io.vertx.mutiny.core.MultiMap;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.core.http.Cookie;
import io.vertx.mutiny.core.http.HttpFrame;
import io.vertx.mutiny.core.net.HostAndPort;
import io.vertx.mutiny.core.streams.ReadStream;
import java.util.Set;
import java.util.concurrent.Flow;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

@MutinyGen(value=io.vertx.core.http.HttpServerResponse.class)
public class HttpServerResponse
implements MutinyDelegate,
io.vertx.mutiny.core.streams.WriteStream<Buffer> {
    public static final TypeArg<HttpServerResponse> __TYPE_ARG = new TypeArg(obj -> new HttpServerResponse((io.vertx.core.http.HttpServerResponse)obj), HttpServerResponse::getDelegate);
    private final io.vertx.core.http.HttpServerResponse delegate;
    static final TypeArg<Cookie> TYPE_ARG_0 = new TypeArg(o1 -> Cookie.newInstance((io.vertx.core.http.Cookie)o1), o1 -> o1.getDelegate());
    static final TypeArg<Cookie> TYPE_ARG_1 = new TypeArg(o1 -> Cookie.newInstance((io.vertx.core.http.Cookie)o1), o1 -> o1.getDelegate());
    private WriteStreamSubscriber<Buffer> subscriber;
    private MultiMap cached_0;
    private MultiMap cached_1;

    public HttpServerResponse(io.vertx.core.http.HttpServerResponse delegate) {
        this.delegate = delegate;
    }

    public HttpServerResponse(Object delegate) {
        this.delegate = (io.vertx.core.http.HttpServerResponse)delegate;
    }

    HttpServerResponse() {
        this.delegate = null;
    }

    public io.vertx.core.http.HttpServerResponse getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpServerResponse that = (HttpServerResponse)o;
        return this.delegate.equals((Object)that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @CheckReturnValue
    public synchronized WriteStreamSubscriber<Buffer> toSubscriber() {
        if (this.subscriber == null) {
            Function<Buffer, io.vertx.core.buffer.Buffer> conv = Buffer::getDelegate;
            this.subscriber = MutinyHelper.toSubscriber((WriteStream)this.getDelegate(), conv);
        }
        return this.subscriber;
    }

    @Override
    @CheckReturnValue
    public Uni<Void> write(Buffer data) {
        return AsyncResultUni.toUni(handler -> this.delegate.write((Object)data.getDelegate(), handler));
    }

    @Override
    public Void writeAndAwait(Buffer data) {
        return (Void)this.write(data).await().indefinitely();
    }

    @Override
    public void writeAndForget(Buffer data) {
        this.write(data).subscribe().with(UniHelper.NOOP);
    }

    @Override
    @CheckReturnValue
    public Uni<Void> end() {
        return AsyncResultUni.toUni(handler -> this.delegate.end(handler));
    }

    @Override
    public Void endAndAwait() {
        return (Void)this.end().await().indefinitely();
    }

    @Override
    public void endAndForget() {
        this.end().subscribe().with(UniHelper.NOOP);
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Fluent
    private HttpServerResponse __exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    @Override
    public HttpServerResponse exceptionHandler(Consumer<Throwable> handler) {
        return this.__exceptionHandler((Handler<Throwable>)MutinyHelper.convertConsumer(handler));
    }

    @Fluent
    public HttpServerResponse setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    @Fluent
    private HttpServerResponse __drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    public HttpServerResponse drainHandler(Runnable handler) {
        return this.__drainHandler((Handler<Void>)((Handler)ignored -> handler.run()));
    }

    public int getStatusCode() {
        int ret = this.delegate.getStatusCode();
        return ret;
    }

    @Fluent
    public HttpServerResponse setStatusCode(int statusCode) {
        this.delegate.setStatusCode(statusCode);
        return this;
    }

    public String getStatusMessage() {
        String ret = this.delegate.getStatusMessage();
        return ret;
    }

    @Fluent
    public HttpServerResponse setStatusMessage(String statusMessage) {
        this.delegate.setStatusMessage(statusMessage);
        return this;
    }

    @Fluent
    public HttpServerResponse setChunked(boolean chunked) {
        this.delegate.setChunked(chunked);
        return this;
    }

    public boolean isChunked() {
        boolean ret = this.delegate.isChunked();
        return ret;
    }

    public MultiMap headers() {
        MultiMap ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = MultiMap.newInstance(this.delegate.headers());
        return ret;
    }

    @Fluent
    public HttpServerResponse putHeader(String name, String value) {
        this.delegate.putHeader(name, value);
        return this;
    }

    public MultiMap trailers() {
        MultiMap ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = MultiMap.newInstance(this.delegate.trailers());
        return ret;
    }

    @Fluent
    public HttpServerResponse putTrailer(String name, String value) {
        this.delegate.putTrailer(name, value);
        return this;
    }

    @Fluent
    private HttpServerResponse __closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    public HttpServerResponse closeHandler(Runnable handler) {
        return this.__closeHandler((Handler<Void>)((Handler)ignored -> handler.run()));
    }

    @Fluent
    private HttpServerResponse __endHandler(Handler<Void> handler) {
        this.delegate.endHandler(handler);
        return this;
    }

    public HttpServerResponse endHandler(Runnable handler) {
        return this.__endHandler((Handler<Void>)((Handler)ignored -> handler.run()));
    }

    @CheckReturnValue
    public Uni<Void> write(String chunk, String enc) {
        return AsyncResultUni.toUni(handler -> this.delegate.write(chunk, enc, handler));
    }

    public Void writeAndAwait(String chunk, String enc) {
        return (Void)this.write(chunk, enc).await().indefinitely();
    }

    public void writeAndForget(String chunk, String enc) {
        this.write(chunk, enc).subscribe().with(UniHelper.NOOP);
    }

    @Override
    @CheckReturnValue
    public Uni<Void> write(String chunk) {
        return AsyncResultUni.toUni(handler -> this.delegate.write(chunk, handler));
    }

    @Override
    public Void writeAndAwait(String chunk) {
        return (Void)this.write(chunk).await().indefinitely();
    }

    @Override
    public void writeAndForget(String chunk) {
        this.write(chunk).subscribe().with(UniHelper.NOOP);
    }

    @Fluent
    public HttpServerResponse writeContinue() {
        this.delegate.writeContinue();
        return this;
    }

    @CheckReturnValue
    public Uni<Void> writeEarlyHints(MultiMap headers) {
        return AsyncResultUni.toUni(handler -> this.delegate.writeEarlyHints(headers.getDelegate(), handler));
    }

    public Void writeEarlyHintsAndAwait(MultiMap headers) {
        return (Void)this.writeEarlyHints(headers).await().indefinitely();
    }

    public void writeEarlyHintsAndForget(MultiMap headers) {
        this.writeEarlyHints(headers).subscribe().with(UniHelper.NOOP);
    }

    @Override
    @CheckReturnValue
    public Uni<Void> end(String chunk) {
        return AsyncResultUni.toUni(handler -> this.delegate.end(chunk, handler));
    }

    @Override
    public Void endAndAwait(String chunk) {
        return (Void)this.end(chunk).await().indefinitely();
    }

    @Override
    public void endAndForget(String chunk) {
        this.end(chunk).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> end(String chunk, String enc) {
        return AsyncResultUni.toUni(handler -> this.delegate.end(chunk, enc, handler));
    }

    public Void endAndAwait(String chunk, String enc) {
        return (Void)this.end(chunk, enc).await().indefinitely();
    }

    public void endAndForget(String chunk, String enc) {
        this.end(chunk, enc).subscribe().with(UniHelper.NOOP);
    }

    @Override
    @CheckReturnValue
    public Uni<Void> end(Buffer chunk) {
        return AsyncResultUni.toUni(handler -> this.delegate.end(chunk.getDelegate(), handler));
    }

    @Override
    public Void endAndAwait(Buffer chunk) {
        return (Void)this.end(chunk).await().indefinitely();
    }

    @Override
    public void endAndForget(Buffer chunk) {
        this.end(chunk).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> send() {
        return AsyncResultUni.toUni(handler -> this.delegate.send(handler));
    }

    public Void sendAndAwait() {
        return (Void)this.send().await().indefinitely();
    }

    public void sendAndForget() {
        this.send().subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> send(String body) {
        return AsyncResultUni.toUni(handler -> this.delegate.send(body, handler));
    }

    public Void sendAndAwait(String body) {
        return (Void)this.send(body).await().indefinitely();
    }

    public void sendAndForget(String body) {
        this.send(body).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> send(Buffer body) {
        return AsyncResultUni.toUni(handler -> this.delegate.send(body.getDelegate(), handler));
    }

    public Void sendAndAwait(Buffer body) {
        return (Void)this.send(body).await().indefinitely();
    }

    public void sendAndForget(Buffer body) {
        this.send(body).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> send(ReadStream<Buffer> body) {
        return AsyncResultUni.toUni(handler -> this.delegate.send(body.getDelegate(), handler));
    }

    public Void sendAndAwait(ReadStream<Buffer> body) {
        return (Void)this.send(body).await().indefinitely();
    }

    public void sendAndForget(ReadStream<Buffer> body) {
        this.send(body).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> send(Flow.Publisher<Buffer> body) {
        return AsyncResultUni.toUni(handler -> this.delegate.send(ReadStreamSubscriber.asReadStream((Flow.Publisher)body, obj -> obj.getDelegate()).resume(), handler));
    }

    public Void sendAndAwait(Flow.Publisher<Buffer> body) {
        return (Void)this.send(body).await().indefinitely();
    }

    public void sendAndForget(Flow.Publisher<Buffer> body) {
        this.send(body).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> sendFile(String filename) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.sendFile(filename, resultHandler));
    }

    public Void sendFileAndAwait(String filename) {
        return (Void)this.sendFile(filename).await().indefinitely();
    }

    @Fluent
    public HttpServerResponse sendFileAndForget(String filename) {
        this.sendFile(filename).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> sendFile(String filename, long offset) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.sendFile(filename, offset, resultHandler));
    }

    public Void sendFileAndAwait(String filename, long offset) {
        return (Void)this.sendFile(filename, offset).await().indefinitely();
    }

    @Fluent
    public HttpServerResponse sendFileAndForget(String filename, long offset) {
        this.sendFile(filename, offset).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> sendFile(String filename, long offset, long length) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.sendFile(filename, offset, length, resultHandler));
    }

    public Void sendFileAndAwait(String filename, long offset, long length) {
        return (Void)this.sendFile(filename, offset, length).await().indefinitely();
    }

    @Fluent
    public HttpServerResponse sendFileAndForget(String filename, long offset, long length) {
        this.sendFile(filename, offset, length).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Deprecated
    public void close() {
        this.delegate.close();
    }

    public boolean ended() {
        boolean ret = this.delegate.ended();
        return ret;
    }

    public boolean closed() {
        boolean ret = this.delegate.closed();
        return ret;
    }

    public boolean headWritten() {
        boolean ret = this.delegate.headWritten();
        return ret;
    }

    @Fluent
    private HttpServerResponse __headersEndHandler(Handler<Void> handler) {
        this.delegate.headersEndHandler(handler);
        return this;
    }

    public HttpServerResponse headersEndHandler(Runnable handler) {
        return this.__headersEndHandler((Handler<Void>)((Handler)ignored -> handler.run()));
    }

    @Fluent
    private HttpServerResponse __bodyEndHandler(Handler<Void> handler) {
        this.delegate.bodyEndHandler(handler);
        return this;
    }

    public HttpServerResponse bodyEndHandler(Runnable handler) {
        return this.__bodyEndHandler((Handler<Void>)((Handler)ignored -> handler.run()));
    }

    public long bytesWritten() {
        long ret = this.delegate.bytesWritten();
        return ret;
    }

    public int streamId() {
        int ret = this.delegate.streamId();
        return ret;
    }

    @CheckReturnValue
    @Deprecated
    public Uni<HttpServerResponse> push(HttpMethod method, String host, String path) {
        return AsyncResultUni.toUni(handler -> this.delegate.push(method, host, path, MutinyHelper.convertHandler((Handler)handler, ar -> ar.map(event -> HttpServerResponse.newInstance(event)))));
    }

    @Deprecated
    public HttpServerResponse pushAndAwait(HttpMethod method, String host, String path) {
        return (HttpServerResponse)this.push(method, host, path).await().indefinitely();
    }

    @Deprecated
    @Fluent
    public HttpServerResponse pushAndForget(HttpMethod method, String host, String path) {
        this.push(method, host, path).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<HttpServerResponse> push(HttpMethod method, HostAndPort host, String path) {
        return AsyncResultUni.toUni(handler -> this.delegate.push(method, host.getDelegate(), path, MutinyHelper.convertHandler((Handler)handler, ar -> ar.map(event -> HttpServerResponse.newInstance(event)))));
    }

    public HttpServerResponse pushAndAwait(HttpMethod method, HostAndPort host, String path) {
        return (HttpServerResponse)this.push(method, host, path).await().indefinitely();
    }

    @Fluent
    public HttpServerResponse pushAndForget(HttpMethod method, HostAndPort host, String path) {
        this.push(method, host, path).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<HttpServerResponse> push(HttpMethod method, String path, MultiMap headers) {
        return AsyncResultUni.toUni(handler -> this.delegate.push(method, path, headers.getDelegate(), MutinyHelper.convertHandler((Handler)handler, ar -> ar.map(event -> HttpServerResponse.newInstance(event)))));
    }

    public HttpServerResponse pushAndAwait(HttpMethod method, String path, MultiMap headers) {
        return (HttpServerResponse)this.push(method, path, headers).await().indefinitely();
    }

    @Fluent
    public HttpServerResponse pushAndForget(HttpMethod method, String path, MultiMap headers) {
        this.push(method, path, headers).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<HttpServerResponse> push(HttpMethod method, String path) {
        return AsyncResultUni.toUni(handler -> this.delegate.push(method, path, MutinyHelper.convertHandler((Handler)handler, ar -> ar.map(event -> HttpServerResponse.newInstance(event)))));
    }

    public HttpServerResponse pushAndAwait(HttpMethod method, String path) {
        return (HttpServerResponse)this.push(method, path).await().indefinitely();
    }

    @Fluent
    public HttpServerResponse pushAndForget(HttpMethod method, String path) {
        this.push(method, path).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    @Deprecated
    public Uni<HttpServerResponse> push(HttpMethod method, String host, String path, MultiMap headers) {
        return AsyncResultUni.toUni(handler -> this.delegate.push(method, host, path, headers.getDelegate(), MutinyHelper.convertHandler((Handler)handler, ar -> ar.map(event -> HttpServerResponse.newInstance(event)))));
    }

    @Deprecated
    public HttpServerResponse pushAndAwait(HttpMethod method, String host, String path, MultiMap headers) {
        return (HttpServerResponse)this.push(method, host, path, headers).await().indefinitely();
    }

    @Deprecated
    @Fluent
    public HttpServerResponse pushAndForget(HttpMethod method, String host, String path, MultiMap headers) {
        this.push(method, host, path, headers).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<HttpServerResponse> push(HttpMethod method, HostAndPort authority, String path, MultiMap headers) {
        return AsyncResultUni.toUni(handler -> this.delegate.push(method, authority.getDelegate(), path, headers.getDelegate(), MutinyHelper.convertHandler((Handler)handler, ar -> ar.map(event -> HttpServerResponse.newInstance(event)))));
    }

    public HttpServerResponse pushAndAwait(HttpMethod method, HostAndPort authority, String path, MultiMap headers) {
        return (HttpServerResponse)this.push(method, authority, path, headers).await().indefinitely();
    }

    @Fluent
    public HttpServerResponse pushAndForget(HttpMethod method, HostAndPort authority, String path, MultiMap headers) {
        this.push(method, authority, path, headers).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public boolean reset() {
        boolean ret = this.delegate.reset();
        return ret;
    }

    public boolean reset(long code) {
        boolean ret = this.delegate.reset(code);
        return ret;
    }

    @Fluent
    public HttpServerResponse writeCustomFrame(int type, int flags, Buffer payload) {
        this.delegate.writeCustomFrame(type, flags, payload.getDelegate());
        return this;
    }

    @Fluent
    public HttpServerResponse writeCustomFrame(HttpFrame frame) {
        this.delegate.writeCustomFrame(frame.getDelegate());
        return this;
    }

    @Fluent
    public HttpServerResponse setStreamPriority(StreamPriority streamPriority) {
        this.delegate.setStreamPriority(streamPriority);
        return this;
    }

    @Fluent
    public HttpServerResponse addCookie(Cookie cookie) {
        this.delegate.addCookie(cookie.getDelegate());
        return this;
    }

    public Cookie removeCookie(String name) {
        Cookie ret = Cookie.newInstance(this.delegate.removeCookie(name));
        return ret;
    }

    public Cookie removeCookie(String name, boolean invalidate) {
        Cookie ret = Cookie.newInstance(this.delegate.removeCookie(name, invalidate));
        return ret;
    }

    public Set<Cookie> removeCookies(String name) {
        Set<Cookie> ret = this.delegate.removeCookies(name).stream().map(elt -> Cookie.newInstance(elt)).collect(Collectors.toSet());
        return ret;
    }

    public Set<Cookie> removeCookies(String name, boolean invalidate) {
        Set<Cookie> ret = this.delegate.removeCookies(name, invalidate).stream().map(elt -> Cookie.newInstance(elt)).collect(Collectors.toSet());
        return ret;
    }

    public Cookie removeCookie(String name, String domain, String path) {
        Cookie ret = Cookie.newInstance(this.delegate.removeCookie(name, domain, path));
        return ret;
    }

    public Cookie removeCookie(String name, String domain, String path, boolean invalidate) {
        Cookie ret = Cookie.newInstance(this.delegate.removeCookie(name, domain, path, invalidate));
        return ret;
    }

    @Fluent
    public HttpServerResponse putHeader(CharSequence name, CharSequence value) {
        this.delegate.putHeader(name, value);
        return this;
    }

    @Fluent
    public HttpServerResponse putHeader(String name, Iterable<String> values) {
        this.delegate.putHeader(name, values);
        return this;
    }

    @Fluent
    public HttpServerResponse putHeader(CharSequence name, Iterable<CharSequence> values) {
        this.delegate.putHeader(name, values);
        return this;
    }

    @Fluent
    public HttpServerResponse putTrailer(CharSequence name, CharSequence value) {
        this.delegate.putTrailer(name, value);
        return this;
    }

    @Fluent
    public HttpServerResponse putTrailer(String name, Iterable<String> values) {
        this.delegate.putTrailer(name, values);
        return this;
    }

    @Fluent
    public HttpServerResponse putTrailer(CharSequence name, Iterable<CharSequence> value) {
        this.delegate.putTrailer(name, value);
        return this;
    }

    public static HttpServerResponse newInstance(io.vertx.core.http.HttpServerResponse arg) {
        return arg != null ? new HttpServerResponse(arg) : null;
    }
}

