package io.vertx.mutiny.core.http;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.http.GoAway;
import io.vertx.core.http.Http2Settings;
import io.vertx.core.Future;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSession;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Represents an HTTP connection.
 * <p/>
 * HTTP/1.x connection provides an limited implementation, the following methods are implemented:
 * <ul>
 *   <li>{@link io.vertx.mutiny.core.http.HttpConnection#close}</li>
 *   <li>{@link io.vertx.mutiny.core.http.HttpConnection#closeHandler}</li>
 *   <li>{@link io.vertx.mutiny.core.http.HttpConnection#exceptionHandler}</li>
 * </ul>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.HttpConnection original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.http.HttpConnection.class)
public class HttpConnection implements io.smallrye.mutiny.vertx.MutinyDelegate {

  public static final io.smallrye.mutiny.vertx.TypeArg<HttpConnection> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new HttpConnection((io.vertx.core.http.HttpConnection) obj),
    HttpConnection::getDelegate
  );

  private final io.vertx.core.http.HttpConnection delegate;
  
  public HttpConnection(io.vertx.core.http.HttpConnection delegate) {
    this.delegate = delegate;
  }

  public HttpConnection(Object delegate) {
    this.delegate = (io.vertx.core.http.HttpConnection)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  HttpConnection() {
    this.delegate = null;
  }

  @Override
  public io.vertx.core.http.HttpConnection getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpConnection that = (HttpConnection) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return the current connection window size or <code>-1</code> for HTTP/1.x
   */
  public int getWindowSize() { 
    int ret = delegate.getWindowSize();
    return ret;
  }

  /**
   * @param windowSize the new window size
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.core.http.HttpConnection setWindowSize(int windowSize) { 
    delegate.setWindowSize(windowSize);
    return this;
  }

  /**
   * @param errorCode 
   * @return the instance of HttpConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.http.HttpConnection goAway(long errorCode) { 
    delegate.goAway(errorCode);
    return this;
  }

  /**
   * @param errorCode 
   * @param lastStreamId 
   * @return the instance of HttpConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.http.HttpConnection goAway(long errorCode, int lastStreamId) { 
    delegate.goAway(errorCode, lastStreamId);
    return this;
  }

  /**
   * @param errorCode the  error code
   * @param lastStreamId the last stream id
   * @param debugData additional debug data sent to the remote endpoint
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.core.http.HttpConnection goAway(long errorCode, int lastStreamId, io.vertx.mutiny.core.buffer.Buffer debugData) { 
    delegate.goAway(errorCode, lastStreamId, debugData.getDelegate());
    return this;
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.core.http.HttpConnection __goAwayHandler(Handler<io.vertx.core.http.GoAway> handler) { 
    delegate.goAwayHandler(handler);
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.core.http.HttpConnection goAwayHandler(java.util.function.Consumer<io.vertx.core.http.GoAway> handler) {
    return __goAwayHandler(io.smallrye.mutiny.vertx.MutinyHelper.convertConsumer(handler));
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.core.http.HttpConnection __shutdownHandler(Handler<Void> handler) { 
    delegate.shutdownHandler(handler);
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.core.http.HttpConnection shutdownHandler(java.lang.Runnable handler) {
    return __shutdownHandler(ignored -> handler.run()
);
  }

  /**
   * Shutdown a 30 seconds timeout (<code>shutdown(30, TimeUnit.SECONDS)</code>).
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> shutdown() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.shutdown(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpConnection#shutdown}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void shutdownAndAwait() { 
    return (Void) shutdown().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpConnection#shutdown} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpConnection#shutdown}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpConnection#shutdown} but you don't need to compose it with other operations.
   */
  public void shutdownAndForget() { 
    shutdown().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Like {@link io.vertx.mutiny.core.http.HttpConnection#shutdown}, in milliseconds.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param timeout 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   * @deprecated instead use {@link #shutdown(long, TimeUnit, Handler)}   */
  @CheckReturnValue
  @Deprecated
  public io.smallrye.mutiny.Uni<Void> shutdown(long timeout) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.shutdown(timeout, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpConnection#shutdown(long)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param timeout 
   * @return the Void instance produced by the operation.
   * @deprecated instead use {@link #shutdown(long, TimeUnit, Handler)}   */
  @Deprecated
  public Void shutdownAndAwait(long timeout) { 
    return (Void) shutdown(timeout).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpConnection#shutdown(long)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpConnection#shutdown(long)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpConnection#shutdown(long)} but you don't need to compose it with other operations.
   * @param timeout 
   * @deprecated instead use {@link #shutdown(long, TimeUnit, Handler)}   */
  @Deprecated
  public void shutdownAndForget(long timeout) { 
    shutdown(timeout).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Initiate a graceful connection shutdown, the connection is taken out of service and closed when all the inflight requests
   * are processed, otherwise after a <code>timeout</code> the connection will be closed. Client connection are immediately removed
   * from the pool.
   *
   * <ul>
   *   <li>HTTP/2 connections will send a go away frame immediately to signal the other side the connection will close.</li>
   *   <li>HTTP/1.x connection will be closed.</li>
   * </ul>
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param timeout the amount of time after which all resources are forcibly closed
   * @param unit the of the timeout
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> shutdown(long timeout, java.util.concurrent.TimeUnit unit) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.shutdown(timeout, unit, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpConnection#shutdown(long,TimeUnit)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param timeout the amount of time after which all resources are forcibly closed
   * @param unit the of the timeout
   * @return the Void instance produced by the operation.
   */
  public Void shutdownAndAwait(long timeout, java.util.concurrent.TimeUnit unit) { 
    return (Void) shutdown(timeout, unit).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpConnection#shutdown(long,TimeUnit)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpConnection#shutdown(long,TimeUnit)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpConnection#shutdown(long,TimeUnit)} but you don't need to compose it with other operations.
   * @param timeout the amount of time after which all resources are forcibly closed
   * @param unit the of the timeout
   */
  public void shutdownAndForget(long timeout, java.util.concurrent.TimeUnit unit) { 
    shutdown(timeout, unit).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @param handler the handler to be notified
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.core.http.HttpConnection __closeHandler(Handler<Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * @param handler the handler to be notified
   * @return 
   */
  public io.vertx.mutiny.core.http.HttpConnection closeHandler(java.lang.Runnable handler) {
    return __closeHandler(ignored -> handler.run()
);
  }

  /**
   * Close the connection and all the currently active streams.
   * <p/>
   * An HTTP/2 connection will send a  frame before.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.close(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpConnection#close}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpConnection#close} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpConnection#close}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpConnection#close} but you don't need to compose it with other operations.
   */
  public void closeAndForget() { 
    close().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @return the latest server settings acknowledged by the remote endpoint - this is not implemented for HTTP/1.x
   */
  public io.vertx.core.http.Http2Settings settings() { 
    io.vertx.core.http.Http2Settings ret = delegate.settings();
    return ret;
  }

  /**
   * Send to the remote endpoint an update of this endpoint settings
   * <p/>
   * The <code>completionHandler</code> will be notified when the remote endpoint has acknowledged the settings.
   * <p/>
   * This is not implemented for HTTP/1.x.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param settings the new settings
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> updateSettings(io.vertx.core.http.Http2Settings settings) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.updateSettings(settings, completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpConnection#updateSettings(Http2Settings)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param settings the new settings
   * @return the Void instance produced by the operation.
   */
  public Void updateSettingsAndAwait(io.vertx.core.http.Http2Settings settings) { 
    return (Void) updateSettings(settings).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpConnection#updateSettings(Http2Settings)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpConnection#updateSettings(Http2Settings)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpConnection#updateSettings(Http2Settings)} but you don't need to compose it with other operations.
   * @param settings the new settings
   * @return the instance of HttpConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.http.HttpConnection updateSettingsAndForget(io.vertx.core.http.Http2Settings settings) { 
    updateSettings(settings).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * @return the current remote endpoint settings for this connection - this is not implemented for HTTP/1.x
   */
  public io.vertx.core.http.Http2Settings remoteSettings() { 
    io.vertx.core.http.Http2Settings ret = delegate.remoteSettings();
    return ret;
  }

  /**
   * @param handler the handler for remote endpoint settings
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.core.http.HttpConnection __remoteSettingsHandler(Handler<io.vertx.core.http.Http2Settings> handler) { 
    delegate.remoteSettingsHandler(handler);
    return this;
  }

  /**
   * @param handler the handler for remote endpoint settings
   * @return 
   */
  public io.vertx.mutiny.core.http.HttpConnection remoteSettingsHandler(java.util.function.Consumer<io.vertx.core.http.Http2Settings> handler) {
    return __remoteSettingsHandler(io.smallrye.mutiny.vertx.MutinyHelper.convertConsumer(handler));
  }

  /**
   * Send a  frame to the remote endpoint.
   * <p/>
   * This is not implemented for HTTP/1.x.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param data the 8 bytes data of the frame
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.core.buffer.Buffer> ping(io.vertx.mutiny.core.buffer.Buffer data) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(pongHandler -> {
        delegate.ping(data.getDelegate(), io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(pongHandler, ar -> ar.map(event -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpConnection#ping(io.vertx.mutiny.core.buffer.Buffer)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param data the 8 bytes data of the frame
   * @return the Buffer instance produced by the operation.
   */
  public io.vertx.mutiny.core.buffer.Buffer pingAndAwait(io.vertx.mutiny.core.buffer.Buffer data) { 
    return (io.vertx.mutiny.core.buffer.Buffer) ping(data).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpConnection#ping(io.vertx.mutiny.core.buffer.Buffer)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpConnection#ping(io.vertx.mutiny.core.buffer.Buffer)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpConnection#ping(io.vertx.mutiny.core.buffer.Buffer)} but you don't need to compose it with other operations.
   * @param data the 8 bytes data of the frame
   * @return the instance of HttpConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.http.HttpConnection pingAndForget(io.vertx.mutiny.core.buffer.Buffer data) { 
    ping(data).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * @param handler the handler to be called when a  is received
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.core.http.HttpConnection __pingHandler(Handler<io.vertx.mutiny.core.buffer.Buffer> handler) { 
    delegate.pingHandler(io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, event -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)event)));
    return this;
  }

  /**
   * @param handler the handler to be called when a  is received
   * @return 
   */
  public io.vertx.mutiny.core.http.HttpConnection pingHandler(java.util.function.Consumer<io.vertx.mutiny.core.buffer.Buffer> handler) {
    return __pingHandler(io.smallrye.mutiny.vertx.MutinyHelper.convertConsumer(handler));
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.core.http.HttpConnection __exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   */
  public io.vertx.mutiny.core.http.HttpConnection exceptionHandler(java.util.function.Consumer<java.lang.Throwable> handler) {
    return __exceptionHandler(io.smallrye.mutiny.vertx.MutinyHelper.convertConsumer(handler));
  }

  /**
   * @return the remote address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket). If <code>useProxyProtocol</code> is set to <code>true</code>, the address returned will be of the actual connecting client.
   */
  public io.vertx.mutiny.core.net.SocketAddress remoteAddress() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.mutiny.core.net.SocketAddress ret = io.vertx.mutiny.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)delegate.remoteAddress());
    cached_0 = ret;
    return ret;
  }

  /**
   * @param real 
   * @return 
   */
  public io.vertx.mutiny.core.net.SocketAddress remoteAddress(boolean real) { 
    io.vertx.mutiny.core.net.SocketAddress ret = io.vertx.mutiny.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)delegate.remoteAddress(real));
    return ret;
  }

  /**
   * @return the local address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket) If <code>useProxyProtocol</code> is set to <code>true</code>, the address returned will be of the proxy.
   */
  public io.vertx.mutiny.core.net.SocketAddress localAddress() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.mutiny.core.net.SocketAddress ret = io.vertx.mutiny.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)delegate.localAddress());
    cached_1 = ret;
    return ret;
  }

  /**
   * @param real 
   * @return 
   */
  public io.vertx.mutiny.core.net.SocketAddress localAddress(boolean real) { 
    io.vertx.mutiny.core.net.SocketAddress ret = io.vertx.mutiny.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)delegate.localAddress(real));
    return ret;
  }

  /**
   * @return true if this {@link io.vertx.mutiny.core.http.HttpConnection} is encrypted via SSL/TLS.
   */
  public boolean isSsl() { 
    boolean ret = delegate.isSsl();
    return ret;
  }

  /**
   * @return the indicated server name
   */
  public String indicatedServerName() { 
    String ret = delegate.indicatedServerName();
    return ret;
  }

  /**
   * @return SSLSession associated with the underlying socket. Returns null if connection is not SSL.
   */
  public javax.net.ssl.SSLSession sslSession() { 
    javax.net.ssl.SSLSession ret = delegate.sslSession();
    return ret;
  }

  private io.vertx.mutiny.core.net.SocketAddress cached_0;
  private io.vertx.mutiny.core.net.SocketAddress cached_1;
  public static  HttpConnection newInstance(io.vertx.core.http.HttpConnection arg) {
    return arg != null ? new HttpConnection(arg) : null;
  }

}
