package io.vertx.mutiny.core.http;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.Future;
import java.util.List;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Represents a client-side HTTP response.
 * <p>
 * Vert.x provides you with one of these via the handler that was provided when creating the {@link io.vertx.mutiny.core.http.HttpClientRequest}
 * or that was set on the {@link io.vertx.mutiny.core.http.HttpClientRequest} instance.
 * <p>
 * It implements {@link io.vertx.mutiny.core.streams.ReadStream} so it can be used with
 * {@link io.vertx.mutiny.core.streams.Pipe} to pipe data with flow control.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.HttpClientResponse original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.http.HttpClientResponse.class)
public class HttpClientResponse implements io.smallrye.mutiny.vertx.MutinyDelegate, io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.core.buffer.Buffer>, io.vertx.mutiny.core.http.HttpResponseHead {

  public static final io.smallrye.mutiny.vertx.TypeArg<HttpClientResponse> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new HttpClientResponse((io.vertx.core.http.HttpClientResponse) obj),
    HttpClientResponse::getDelegate
  );

  private final io.vertx.core.http.HttpClientResponse delegate;
  
  public HttpClientResponse(io.vertx.core.http.HttpClientResponse delegate) {
    this.delegate = delegate;
  }

  public HttpClientResponse(Object delegate) {
    this.delegate = (io.vertx.core.http.HttpClientResponse)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  HttpClientResponse() {
    this.delegate = null;
  }

  @Override
  public io.vertx.core.http.HttpClientResponse getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_0 = new TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpClientResponse that = (HttpClientResponse) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return the version of the response
   */
  public io.vertx.core.http.HttpVersion version() { 
    io.vertx.core.http.HttpVersion ret = delegate.version();
    return ret;
  }

  /**
   * @return the status code of the response
   */
  public int statusCode() { 
    int ret = delegate.statusCode();
    return ret;
  }

  /**
   * @return the status message of the response
   */
  public String statusMessage() { 
    String ret = delegate.statusMessage();
    return ret;
  }

  /**
   * @return the headers
   */
  public io.vertx.mutiny.core.MultiMap headers() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.mutiny.core.MultiMap ret = io.vertx.mutiny.core.MultiMap.newInstance((io.vertx.core.MultiMap)delegate.headers());
    cached_0 = ret;
    return ret;
  }

  /**
   * @param headerName the header name
   * @return the header value
   */
  public String getHeader(String headerName) { 
    String ret = delegate.getHeader(headerName);
    return ret;
  }

  /**
   * @return the Set-Cookie headers (including trailers)
   */
  public List<String> cookies() { 
    if (cached_1 != null) {
      return cached_1;
    }
    List<String> ret = delegate.cookies();
    cached_1 = ret;
    return ret;
  }

  /**
   * @return a pipe
   */
  public io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.core.buffer.Buffer> pipe() { 
    io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TYPE_ARG_0);
    return ret;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param dst the destination write stream
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.pipeTo(dst.getDelegate(), handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param dst the destination write stream
   * @return the Void instance produced by the operation.
   */
  public Void pipeToAndAwait(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst) { 
    return (Void) pipeTo(dst).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.streams.ReadStream#pipeTo(io.vertx.mutiny.core.streams.WriteStream)} but you don't need to compose it with other operations.
   * @param dst the destination write stream
   */
  public void pipeToAndForget(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.core.buffer.Buffer> dst) { 
    pipeTo(dst).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  @Fluent
  public io.vertx.mutiny.core.http.HttpClientResponse fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  @Fluent
  public io.vertx.mutiny.core.http.HttpClientResponse resume() { 
    delegate.resume();
    return this;
  }

  @Fluent
  private io.vertx.mutiny.core.http.HttpClientResponse __exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.mutiny.core.http.HttpClientResponse exceptionHandler(java.util.function.Consumer<java.lang.Throwable> handler) {
    return __exceptionHandler(io.smallrye.mutiny.vertx.MutinyHelper.convertConsumer(handler));
  }

  @Fluent
  private io.vertx.mutiny.core.http.HttpClientResponse __handler(Handler<io.vertx.mutiny.core.buffer.Buffer> handler) { 
    delegate.handler(io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, event -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)event)));
    return this;
  }

  public io.vertx.mutiny.core.http.HttpClientResponse handler(java.util.function.Consumer<io.vertx.mutiny.core.buffer.Buffer> handler) {
    return __handler(io.smallrye.mutiny.vertx.MutinyHelper.convertConsumer(handler));
  }

  @Fluent
  public io.vertx.mutiny.core.http.HttpClientResponse pause() { 
    delegate.pause();
    return this;
  }

  @Fluent
  private io.vertx.mutiny.core.http.HttpClientResponse __endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.mutiny.core.http.HttpClientResponse endHandler(java.lang.Runnable endHandler) {
    return __endHandler(ignored -> endHandler.run()
);
  }

  /**
   * @return a <code>NetSocket</code> facade to interact with the HTTP client response.
   */
  public io.vertx.mutiny.core.net.NetSocket netSocket() { 
    if (cached_2 != null) {
      return cached_2;
    }
    io.vertx.mutiny.core.net.NetSocket ret = io.vertx.mutiny.core.net.NetSocket.newInstance((io.vertx.core.net.NetSocket)delegate.netSocket());
    cached_2 = ret;
    return ret;
  }

  /**
   * @param trailerName the trailer name
   * @return the trailer value
   */
  public String getTrailer(String trailerName) { 
    String ret = delegate.getTrailer(trailerName);
    return ret;
  }

  /**
   * @return the trailers
   */
  public io.vertx.mutiny.core.MultiMap trailers() { 
    if (cached_3 != null) {
      return cached_3;
    }
    io.vertx.mutiny.core.MultiMap ret = io.vertx.mutiny.core.MultiMap.newInstance((io.vertx.core.MultiMap)delegate.trailers());
    cached_3 = ret;
    return ret;
  }

  /**
   * @param bodyHandler This handler will be called after all the body has been received
   * @return the instance of HttpClientResponse to chain method calls.
   */
  @Fluent
  private io.vertx.mutiny.core.http.HttpClientResponse __bodyHandler(Handler<io.vertx.mutiny.core.buffer.Buffer> bodyHandler) { 
    delegate.bodyHandler(io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(bodyHandler, event -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)event)));
    return this;
  }

  /**
   * @param bodyHandler This handler will be called after all the body has been received
   * @return 
   */
  public io.vertx.mutiny.core.http.HttpClientResponse bodyHandler(java.util.function.Consumer<io.vertx.mutiny.core.buffer.Buffer> bodyHandler) {
    return __bodyHandler(io.smallrye.mutiny.vertx.MutinyHelper.convertConsumer(bodyHandler));
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.HttpClientResponse#body} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.core.buffer.Buffer> body() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.body(io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, ar -> ar.map(event -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpClientResponse#body}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Buffer instance produced by the operation.
   */
  public io.vertx.mutiny.core.buffer.Buffer bodyAndAwait() { 
    return (io.vertx.mutiny.core.buffer.Buffer) body().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpClientResponse#body} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpClientResponse#body}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpClientResponse#body} but you don't need to compose it with other operations.
   * @return the instance of HttpClientResponse to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.http.HttpClientResponse bodyAndForget() { 
    body().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Same as {@link io.vertx.mutiny.core.http.HttpClientResponse#end} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> end() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.end(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.http.HttpClientResponse#end}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void endAndAwait() { 
    return (Void) end().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.http.HttpClientResponse#end} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.http.HttpClientResponse#end}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.http.HttpClientResponse#end} but you don't need to compose it with other operations.
   */
  public void endAndForget() { 
    end().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  private io.vertx.mutiny.core.http.HttpClientResponse __customFrameHandler(Handler<io.vertx.mutiny.core.http.HttpFrame> handler) { 
    delegate.customFrameHandler(io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(handler, event -> io.vertx.mutiny.core.http.HttpFrame.newInstance((io.vertx.core.http.HttpFrame)event)));
    return this;
  }

  /**
   * @param handler 
   * @return 
   */
  public io.vertx.mutiny.core.http.HttpClientResponse customFrameHandler(java.util.function.Consumer<io.vertx.mutiny.core.http.HttpFrame> handler) {
    return __customFrameHandler(io.smallrye.mutiny.vertx.MutinyHelper.convertConsumer(handler));
  }

  /**
   * @return the corresponding request
   */
  public io.vertx.mutiny.core.http.HttpClientRequest request() { 
    if (cached_4 != null) {
      return cached_4;
    }
    io.vertx.mutiny.core.http.HttpClientRequest ret = io.vertx.mutiny.core.http.HttpClientRequest.newInstance((io.vertx.core.http.HttpClientRequest)delegate.request());
    cached_4 = ret;
    return ret;
  }

  /**
   * @param handler the handler to be called when the stream priority changes
   * @return the instance of HttpClientResponse to chain method calls.
   */
  @Fluent
  private io.vertx.mutiny.core.http.HttpClientResponse __streamPriorityHandler(Handler<io.vertx.core.http.StreamPriority> handler) { 
    delegate.streamPriorityHandler(handler);
    return this;
  }

  /**
   * @param handler the handler to be called when the stream priority changes
   * @return 
   */
  public io.vertx.mutiny.core.http.HttpClientResponse streamPriorityHandler(java.util.function.Consumer<io.vertx.core.http.StreamPriority> handler) {
    return __streamPriorityHandler(io.smallrye.mutiny.vertx.MutinyHelper.convertConsumer(handler));
  }

  /**
   * @param headerName the header name
   * @return the header value
   */
  public String getHeader(java.lang.CharSequence headerName) { 
    String ret = delegate.getHeader(headerName);
    return ret;
  }

  private io.vertx.mutiny.core.MultiMap cached_0;
  private List<String> cached_1;
  private io.vertx.mutiny.core.net.NetSocket cached_2;
  private io.vertx.mutiny.core.MultiMap cached_3;
  private io.vertx.mutiny.core.http.HttpClientRequest cached_4;
  private Multi<io.vertx.mutiny.core.buffer.Buffer> multi;

  @CheckReturnValue
  public synchronized Multi<io.vertx.mutiny.core.buffer.Buffer> toMulti() {
    if (multi == null) {
      java.util.function.Function<io.vertx.core.buffer.Buffer, io.vertx.mutiny.core.buffer.Buffer> conv = io.vertx.mutiny.core.buffer.Buffer::newInstance;
      multi = io.smallrye.mutiny.vertx.MultiHelper.toMulti(delegate, conv);    }
    return multi;
  }

  public java.lang.Iterable<io.vertx.mutiny.core.buffer.Buffer> toBlockingIterable() {
    return toMulti().subscribe().asIterable();
  }

  public java.util.stream.Stream<io.vertx.mutiny.core.buffer.Buffer> toBlockingStream() {
    return toMulti().subscribe().asStream();
  }

  public static  HttpClientResponse newInstance(io.vertx.core.http.HttpClientResponse arg) {
    return arg != null ? new HttpClientResponse(arg) : null;
  }

}
