/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.core.http;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.DelegatingConsumerHandler;
import io.smallrye.mutiny.vertx.DelegatingHandler;
import io.smallrye.mutiny.vertx.MultiHelper;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamPriority;
import io.vertx.mutiny.core.MultiMap;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.core.http.Cookie;
import io.vertx.mutiny.core.http.HttpConnection;
import io.vertx.mutiny.core.http.HttpFrame;
import io.vertx.mutiny.core.http.HttpServerFileUpload;
import io.vertx.mutiny.core.http.HttpServerResponse;
import io.vertx.mutiny.core.http.ServerWebSocket;
import io.vertx.mutiny.core.net.NetSocket;
import io.vertx.mutiny.core.net.SocketAddress;
import io.vertx.mutiny.core.streams.Pipe;
import io.vertx.mutiny.core.streams.ReadStream;
import io.vertx.mutiny.core.streams.WriteStream;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.SSLSession;

@MutinyGen(value=io.vertx.core.http.HttpServerRequest.class)
public class HttpServerRequest
implements ReadStream<Buffer> {
    public static final TypeArg<HttpServerRequest> __TYPE_ARG = new TypeArg(obj -> new HttpServerRequest((io.vertx.core.http.HttpServerRequest)obj), HttpServerRequest::getDelegate);
    private final io.vertx.core.http.HttpServerRequest delegate;
    static final TypeArg<Buffer> TYPE_ARG_0 = new TypeArg(o1 -> Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
    static final TypeArg<Cookie> TYPE_ARG_2 = new TypeArg(o1 -> Cookie.newInstance((io.vertx.core.http.Cookie)o1), o1 -> o1.getDelegate());
    static final TypeArg<Cookie> TYPE_ARG_3 = new TypeArg(o1 -> Cookie.newInstance((io.vertx.core.http.Cookie)o1), o1 -> o1.getDelegate());
    static final TypeArg<Cookie> TYPE_ARG_1 = new TypeArg(o1 -> Cookie.newInstance((io.vertx.core.http.Cookie)o1), o1 -> o1.getDelegate());
    private HttpServerResponse cached_0;
    private MultiMap cached_1;
    private MultiMap cached_2;
    private SocketAddress cached_3;
    private SocketAddress cached_4;
    private MultiMap cached_5;
    private Integer cached_6;
    private HttpConnection cached_7;
    private Multi<Buffer> multi;

    public HttpServerRequest(io.vertx.core.http.HttpServerRequest delegate) {
        this.delegate = delegate;
    }

    public HttpServerRequest(Object delegate) {
        this.delegate = (io.vertx.core.http.HttpServerRequest)delegate;
    }

    HttpServerRequest() {
        this.delegate = null;
    }

    public io.vertx.core.http.HttpServerRequest getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpServerRequest that = (HttpServerRequest)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public Pipe<Buffer> pipe() {
        Pipe<Buffer> ret = Pipe.newInstance(this.delegate.pipe(), TYPE_ARG_0);
        return ret;
    }

    @Override
    @CheckReturnValue
    public Uni<Void> pipeTo(WriteStream<Buffer> dst) {
        return AsyncResultUni.toUni(handler -> this.delegate.pipeTo(dst.getDelegate(), handler));
    }

    @Override
    public Void pipeToAndAwait(WriteStream<Buffer> dst) {
        return (Void)this.pipeTo(dst).await().indefinitely();
    }

    @Override
    public void pipeToAndForget(WriteStream<Buffer> dst) {
        this.pipeTo(dst).subscribe().with(UniHelper.NOOP);
    }

    @Fluent
    private HttpServerRequest __exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    @Override
    public HttpServerRequest exceptionHandler(Consumer<Throwable> handler) {
        return this.__exceptionHandler((Handler<Throwable>)(handler != null ? new DelegatingConsumerHandler(handler) : null));
    }

    @Fluent
    private HttpServerRequest __handler(Handler<Buffer> handler) {
        this.delegate.handler((Handler)new DelegatingHandler(handler, event -> Buffer.newInstance(event)));
        return this;
    }

    public HttpServerRequest handler(Consumer<Buffer> handler) {
        return this.__handler((Handler<Buffer>)(handler != null ? new DelegatingConsumerHandler(handler) : null));
    }

    @Fluent
    public HttpServerRequest pause() {
        this.delegate.pause();
        return this;
    }

    @Fluent
    public HttpServerRequest resume() {
        this.delegate.resume();
        return this;
    }

    @Fluent
    public HttpServerRequest fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    @Fluent
    private HttpServerRequest __endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public HttpServerRequest endHandler(Runnable endHandler) {
        return this.__endHandler((Handler<Void>)((Handler)ignored -> endHandler.run()));
    }

    public HttpVersion version() {
        HttpVersion ret = this.delegate.version();
        return ret;
    }

    public HttpMethod method() {
        HttpMethod ret = this.delegate.method();
        return ret;
    }

    public boolean isSSL() {
        boolean ret = this.delegate.isSSL();
        return ret;
    }

    public String scheme() {
        String ret = this.delegate.scheme();
        return ret;
    }

    public String uri() {
        String ret = this.delegate.uri();
        return ret;
    }

    public String path() {
        String ret = this.delegate.path();
        return ret;
    }

    public String query() {
        String ret = this.delegate.query();
        return ret;
    }

    public String host() {
        String ret = this.delegate.host();
        return ret;
    }

    public long bytesRead() {
        long ret = this.delegate.bytesRead();
        return ret;
    }

    public HttpServerResponse response() {
        HttpServerResponse ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = HttpServerResponse.newInstance(this.delegate.response());
        return ret;
    }

    public MultiMap headers() {
        MultiMap ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = MultiMap.newInstance(this.delegate.headers());
        return ret;
    }

    public String getHeader(String headerName) {
        String ret = this.delegate.getHeader(headerName);
        return ret;
    }

    @Fluent
    public HttpServerRequest setParamsCharset(String charset) {
        this.delegate.setParamsCharset(charset);
        return this;
    }

    public String getParamsCharset() {
        String ret = this.delegate.getParamsCharset();
        return ret;
    }

    public MultiMap params() {
        MultiMap ret;
        if (this.cached_2 != null) {
            return this.cached_2;
        }
        this.cached_2 = ret = MultiMap.newInstance(this.delegate.params());
        return ret;
    }

    public String getParam(String paramName) {
        String ret = this.delegate.getParam(paramName);
        return ret;
    }

    public String getParam(String paramName, String defaultValue) {
        String ret = this.delegate.getParam(paramName, defaultValue);
        return ret;
    }

    public SocketAddress remoteAddress() {
        SocketAddress ret;
        if (this.cached_3 != null) {
            return this.cached_3;
        }
        this.cached_3 = ret = SocketAddress.newInstance(this.delegate.remoteAddress());
        return ret;
    }

    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_4 != null) {
            return this.cached_4;
        }
        this.cached_4 = ret = SocketAddress.newInstance(this.delegate.localAddress());
        return ret;
    }

    public String absoluteURI() {
        String ret = this.delegate.absoluteURI();
        return ret;
    }

    @Fluent
    private HttpServerRequest __bodyHandler(Handler<Buffer> bodyHandler) {
        this.delegate.bodyHandler((Handler)new DelegatingHandler(bodyHandler, event -> Buffer.newInstance(event)));
        return this;
    }

    public HttpServerRequest bodyHandler(Consumer<Buffer> bodyHandler) {
        return this.__bodyHandler((Handler<Buffer>)(bodyHandler != null ? new DelegatingConsumerHandler(bodyHandler) : null));
    }

    @CheckReturnValue
    public Uni<Buffer> body() {
        return AsyncResultUni.toUni(handler -> this.delegate.body((Handler)new DelegatingHandler(handler, ar -> ar.map(event -> Buffer.newInstance(event)))));
    }

    public Buffer bodyAndAwait() {
        return (Buffer)this.body().await().indefinitely();
    }

    public void bodyAndForget() {
        this.body().subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> end() {
        return AsyncResultUni.toUni(handler -> this.delegate.end(handler));
    }

    public Void endAndAwait() {
        return (Void)this.end().await().indefinitely();
    }

    public void endAndForget() {
        this.end().subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<NetSocket> toNetSocket() {
        return AsyncResultUni.toUni(handler -> this.delegate.toNetSocket((Handler)new DelegatingHandler(handler, ar -> ar.map(event -> NetSocket.newInstance(event)))));
    }

    public NetSocket toNetSocketAndAwait() {
        return (NetSocket)this.toNetSocket().await().indefinitely();
    }

    public void toNetSocketAndForget() {
        this.toNetSocket().subscribe().with(UniHelper.NOOP);
    }

    @Fluent
    public HttpServerRequest setExpectMultipart(boolean expect) {
        this.delegate.setExpectMultipart(expect);
        return this;
    }

    public boolean isExpectMultipart() {
        boolean ret = this.delegate.isExpectMultipart();
        return ret;
    }

    @Fluent
    private HttpServerRequest __uploadHandler(Handler<HttpServerFileUpload> uploadHandler) {
        this.delegate.uploadHandler((Handler)new DelegatingHandler(uploadHandler, event -> HttpServerFileUpload.newInstance(event)));
        return this;
    }

    public HttpServerRequest uploadHandler(Consumer<HttpServerFileUpload> uploadHandler) {
        return this.__uploadHandler((Handler<HttpServerFileUpload>)(uploadHandler != null ? new DelegatingConsumerHandler(uploadHandler) : null));
    }

    public MultiMap formAttributes() {
        MultiMap ret;
        if (this.cached_5 != null) {
            return this.cached_5;
        }
        this.cached_5 = ret = MultiMap.newInstance(this.delegate.formAttributes());
        return ret;
    }

    public String getFormAttribute(String attributeName) {
        String ret = this.delegate.getFormAttribute(attributeName);
        return ret;
    }

    public int streamId() {
        if (this.cached_6 != null) {
            return this.cached_6;
        }
        int ret = this.delegate.streamId();
        this.cached_6 = ret;
        return ret;
    }

    @CheckReturnValue
    public Uni<ServerWebSocket> toWebSocket() {
        return AsyncResultUni.toUni(handler -> this.delegate.toWebSocket((Handler)new DelegatingHandler(handler, ar -> ar.map(event -> ServerWebSocket.newInstance(event)))));
    }

    public ServerWebSocket toWebSocketAndAwait() {
        return (ServerWebSocket)this.toWebSocket().await().indefinitely();
    }

    public void toWebSocketAndForget() {
        this.toWebSocket().subscribe().with(UniHelper.NOOP);
    }

    public boolean isEnded() {
        boolean ret = this.delegate.isEnded();
        return ret;
    }

    @Fluent
    private HttpServerRequest __customFrameHandler(Handler<HttpFrame> handler) {
        this.delegate.customFrameHandler((Handler)new DelegatingHandler(handler, event -> HttpFrame.newInstance(event)));
        return this;
    }

    public HttpServerRequest customFrameHandler(Consumer<HttpFrame> handler) {
        return this.__customFrameHandler((Handler<HttpFrame>)(handler != null ? new DelegatingConsumerHandler(handler) : null));
    }

    public HttpConnection connection() {
        HttpConnection ret;
        if (this.cached_7 != null) {
            return this.cached_7;
        }
        this.cached_7 = ret = HttpConnection.newInstance(this.delegate.connection());
        return ret;
    }

    public StreamPriority streamPriority() {
        StreamPriority ret = this.delegate.streamPriority();
        return ret;
    }

    @Fluent
    private HttpServerRequest __streamPriorityHandler(Handler<StreamPriority> handler) {
        this.delegate.streamPriorityHandler(handler);
        return this;
    }

    public HttpServerRequest streamPriorityHandler(Consumer<StreamPriority> handler) {
        return this.__streamPriorityHandler((Handler<StreamPriority>)(handler != null ? new DelegatingConsumerHandler(handler) : null));
    }

    public Cookie getCookie(String name) {
        Cookie ret = Cookie.newInstance(this.delegate.getCookie(name));
        return ret;
    }

    public Cookie getCookie(String name, String domain, String path) {
        Cookie ret = Cookie.newInstance(this.delegate.getCookie(name, domain, path));
        return ret;
    }

    public int cookieCount() {
        int ret = this.delegate.cookieCount();
        return ret;
    }

    @Deprecated
    public Map<String, Cookie> cookieMap() {
        Map<String, Cookie> ret = this.delegate.cookieMap().entrySet().stream().collect(Collectors.toMap(_e -> (String)_e.getKey(), _e -> Cookie.newInstance((io.vertx.core.http.Cookie)_e.getValue())));
        return ret;
    }

    public Set<Cookie> cookies(String name) {
        Set<Cookie> ret = this.delegate.cookies(name).stream().map(elt -> Cookie.newInstance(elt)).collect(Collectors.toSet());
        return ret;
    }

    public Set<Cookie> cookies() {
        Set<Cookie> ret = this.delegate.cookies().stream().map(elt -> Cookie.newInstance(elt)).collect(Collectors.toSet());
        return ret;
    }

    @Fluent
    public HttpServerRequest routed(String route) {
        this.delegate.routed(route);
        return this;
    }

    public String getHeader(CharSequence headerName) {
        String ret = this.delegate.getHeader(headerName);
        return ret;
    }

    public SSLSession sslSession() {
        SSLSession ret = this.delegate.sslSession();
        return ret;
    }

    @Override
    @CheckReturnValue
    public synchronized Multi<Buffer> toMulti() {
        if (this.multi == null) {
            Function<io.vertx.core.buffer.Buffer, Buffer> conv = Buffer::newInstance;
            this.multi = MultiHelper.toMulti((io.vertx.core.streams.ReadStream)this.delegate, conv);
        }
        return this.multi;
    }

    public Iterable<Buffer> toBlockingIterable() {
        return this.toMulti().subscribe().asIterable();
    }

    public Stream<Buffer> toBlockingStream() {
        return this.toMulti().subscribe().asStream();
    }

    public static HttpServerRequest newInstance(io.vertx.core.http.HttpServerRequest arg) {
        return arg != null ? new HttpServerRequest(arg) : null;
    }
}

