/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.core.http;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.mutiny.core.http.HttpConnection;
import io.vertx.mutiny.core.http.HttpServerRequest;
import io.vertx.mutiny.core.http.ServerWebSocket;
import io.vertx.mutiny.core.metrics.Measured;
import io.vertx.mutiny.core.net.SocketAddress;
import io.vertx.mutiny.core.streams.ReadStream;
import java.util.function.Consumer;

@MutinyGen(value=io.vertx.core.http.HttpServer.class)
public class HttpServer
implements Measured {
    public static final TypeArg<HttpServer> __TYPE_ARG = new TypeArg(obj -> new HttpServer((io.vertx.core.http.HttpServer)obj), HttpServer::getDelegate);
    private final io.vertx.core.http.HttpServer delegate;
    static final TypeArg<ServerWebSocket> TYPE_ARG_1 = new TypeArg(o1 -> ServerWebSocket.newInstance((io.vertx.core.http.ServerWebSocket)o1), o1 -> o1.getDelegate());
    static final TypeArg<HttpServerRequest> TYPE_ARG_0 = new TypeArg(o1 -> HttpServerRequest.newInstance((io.vertx.core.http.HttpServerRequest)o1), o1 -> o1.getDelegate());
    private ReadStream<HttpServerRequest> cached_0;
    private ReadStream<ServerWebSocket> cached_1;

    public HttpServer(io.vertx.core.http.HttpServer delegate) {
        this.delegate = delegate;
    }

    public HttpServer(Object delegate) {
        this.delegate = (io.vertx.core.http.HttpServer)delegate;
    }

    HttpServer() {
        this.delegate = null;
    }

    public io.vertx.core.http.HttpServer getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpServer that = (HttpServer)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public ReadStream<HttpServerRequest> requestStream() {
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        ReadStream<HttpServerRequest> ret = ReadStream.newInstance(this.delegate.requestStream(), TYPE_ARG_0);
        this.cached_0 = ret;
        return ret;
    }

    @Fluent
    private HttpServer __requestHandler(final Handler<HttpServerRequest> handler) {
        this.delegate.requestHandler((Handler)new Handler<io.vertx.core.http.HttpServerRequest>(){

            public void handle(io.vertx.core.http.HttpServerRequest event) {
                handler.handle((Object)HttpServerRequest.newInstance(event));
            }
        });
        return this;
    }

    public HttpServer requestHandler(Consumer<HttpServerRequest> handler) {
        return this.__requestHandler(handler != null ? handler::accept : null);
    }

    private HttpServer __invalidRequestHandler(final Handler<HttpServerRequest> handler) {
        HttpServer ret = HttpServer.newInstance(this.delegate.invalidRequestHandler((Handler)new Handler<io.vertx.core.http.HttpServerRequest>(){

            public void handle(io.vertx.core.http.HttpServerRequest event) {
                handler.handle((Object)HttpServerRequest.newInstance(event));
            }
        }));
        return ret;
    }

    public HttpServer invalidRequestHandler(Consumer<HttpServerRequest> handler) {
        return this.__invalidRequestHandler(handler != null ? handler::accept : null);
    }

    @Fluent
    private HttpServer __connectionHandler(final Handler<HttpConnection> handler) {
        this.delegate.connectionHandler((Handler)new Handler<io.vertx.core.http.HttpConnection>(){

            public void handle(io.vertx.core.http.HttpConnection event) {
                handler.handle((Object)HttpConnection.newInstance(event));
            }
        });
        return this;
    }

    public HttpServer connectionHandler(Consumer<HttpConnection> handler) {
        return this.__connectionHandler(handler != null ? handler::accept : null);
    }

    @Fluent
    private HttpServer __exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public HttpServer exceptionHandler(Consumer<Throwable> handler) {
        return this.__exceptionHandler(handler != null ? handler::accept : null);
    }

    public ReadStream<ServerWebSocket> webSocketStream() {
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        ReadStream<ServerWebSocket> ret = ReadStream.newInstance(this.delegate.webSocketStream(), TYPE_ARG_1);
        this.cached_1 = ret;
        return ret;
    }

    @Fluent
    private HttpServer __webSocketHandler(final Handler<ServerWebSocket> handler) {
        this.delegate.webSocketHandler((Handler)new Handler<io.vertx.core.http.ServerWebSocket>(){

            public void handle(io.vertx.core.http.ServerWebSocket event) {
                handler.handle((Object)ServerWebSocket.newInstance(event));
            }
        });
        return this;
    }

    public HttpServer webSocketHandler(Consumer<ServerWebSocket> handler) {
        return this.__webSocketHandler(handler != null ? handler::accept : null);
    }

    public Uni<HttpServer> listen(int port, String host) {
        return AsyncResultUni.toUni(listenHandler -> this.delegate.listen(port, host, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpServer>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpServer> ar) {
                if (ar.succeeded()) {
                    listenHandler.handle((Object)Future.succeededFuture((Object)HttpServer.newInstance((io.vertx.core.http.HttpServer)ar.result())));
                } else {
                    listenHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public HttpServer listenAndAwait(int port, String host) {
        return (HttpServer)this.listen(port, host).await().indefinitely();
    }

    @Fluent
    public HttpServer listenAndForget(int port, String host) {
        this.listen(port, host).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public Uni<HttpServer> listen(SocketAddress address) {
        return AsyncResultUni.toUni(listenHandler -> this.delegate.listen(address.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpServer>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpServer> ar) {
                if (ar.succeeded()) {
                    listenHandler.handle((Object)Future.succeededFuture((Object)HttpServer.newInstance((io.vertx.core.http.HttpServer)ar.result())));
                } else {
                    listenHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public HttpServer listenAndAwait(SocketAddress address) {
        return (HttpServer)this.listen(address).await().indefinitely();
    }

    @Fluent
    public HttpServer listenAndForget(SocketAddress address) {
        this.listen(address).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public Uni<HttpServer> listen(int port) {
        return AsyncResultUni.toUni(listenHandler -> this.delegate.listen(port, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpServer>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpServer> ar) {
                if (ar.succeeded()) {
                    listenHandler.handle((Object)Future.succeededFuture((Object)HttpServer.newInstance((io.vertx.core.http.HttpServer)ar.result())));
                } else {
                    listenHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public HttpServer listenAndAwait(int port) {
        return (HttpServer)this.listen(port).await().indefinitely();
    }

    @Fluent
    public HttpServer listenAndForget(int port) {
        this.listen(port).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public Uni<HttpServer> listen() {
        return AsyncResultUni.toUni(listenHandler -> this.delegate.listen((Handler)new Handler<AsyncResult<io.vertx.core.http.HttpServer>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpServer> ar) {
                if (ar.succeeded()) {
                    listenHandler.handle((Object)Future.succeededFuture((Object)HttpServer.newInstance((io.vertx.core.http.HttpServer)ar.result())));
                } else {
                    listenHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public HttpServer listenAndAwait() {
        return (HttpServer)this.listen().await().indefinitely();
    }

    @Fluent
    public HttpServer listenAndForget() {
        this.listen().subscribe().with(UniHelper.NOOP);
        return this;
    }

    public Uni<Void> close() {
        return AsyncResultUni.toUni(completionHandler -> this.delegate.close(completionHandler));
    }

    public Void closeAndAwait() {
        return (Void)this.close().await().indefinitely();
    }

    public void closeAndForget() {
        this.close().subscribe().with(UniHelper.NOOP);
    }

    public int actualPort() {
        int ret = this.delegate.actualPort();
        return ret;
    }

    public static HttpServer newInstance(io.vertx.core.http.HttpServer arg) {
        return arg != null ? new HttpServer(arg) : null;
    }
}

