/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.core.http;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.mutiny.core.http.HttpConnection;
import io.vertx.mutiny.core.http.HttpServerRequest;
import io.vertx.mutiny.core.http.ServerWebSocket;
import io.vertx.mutiny.core.metrics.Measured;
import io.vertx.mutiny.core.net.SocketAddress;
import io.vertx.mutiny.core.streams.ReadStream;
import java.util.function.Consumer;

@MutinyGen(value=io.vertx.core.http.HttpServer.class)
public class HttpServer
implements Measured {
    public static final TypeArg<HttpServer> __TYPE_ARG = new TypeArg(obj -> new HttpServer((io.vertx.core.http.HttpServer)obj), HttpServer::getDelegate);
    private final io.vertx.core.http.HttpServer delegate;
    private ReadStream<HttpServerRequest> cached_0;
    private ReadStream<ServerWebSocket> cached_1;

    public HttpServer(io.vertx.core.http.HttpServer delegate) {
        this.delegate = delegate;
    }

    HttpServer() {
        this.delegate = null;
    }

    public io.vertx.core.http.HttpServer getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpServer that = (HttpServer)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public ReadStream<HttpServerRequest> requestStream() {
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        ReadStream<HttpServerRequest> ret = ReadStream.newInstance(this.delegate.requestStream(), HttpServerRequest.__TYPE_ARG);
        this.cached_0 = ret;
        return ret;
    }

    private HttpServer __requestHandler(final Handler<HttpServerRequest> handler) {
        this.delegate.requestHandler((Handler)new Handler<io.vertx.core.http.HttpServerRequest>(){

            public void handle(io.vertx.core.http.HttpServerRequest event) {
                handler.handle((Object)HttpServerRequest.newInstance(event));
            }
        });
        return this;
    }

    public HttpServer requestHandler(Consumer<HttpServerRequest> handler) {
        return this.__requestHandler(handler != null ? handler::accept : null);
    }

    private HttpServer __connectionHandler(final Handler<HttpConnection> handler) {
        this.delegate.connectionHandler((Handler)new Handler<io.vertx.core.http.HttpConnection>(){

            public void handle(io.vertx.core.http.HttpConnection event) {
                handler.handle((Object)HttpConnection.newInstance(event));
            }
        });
        return this;
    }

    public HttpServer connectionHandler(Consumer<HttpConnection> handler) {
        return this.__connectionHandler(handler != null ? handler::accept : null);
    }

    private HttpServer __exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public HttpServer exceptionHandler(Consumer<Throwable> handler) {
        return this.__exceptionHandler(handler != null ? handler::accept : null);
    }

    public ReadStream<ServerWebSocket> websocketStream() {
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        ReadStream<ServerWebSocket> ret = ReadStream.newInstance(this.delegate.websocketStream(), ServerWebSocket.__TYPE_ARG);
        this.cached_1 = ret;
        return ret;
    }

    private HttpServer __websocketHandler(final Handler<ServerWebSocket> handler) {
        this.delegate.websocketHandler((Handler)new Handler<io.vertx.core.http.ServerWebSocket>(){

            public void handle(io.vertx.core.http.ServerWebSocket event) {
                handler.handle((Object)ServerWebSocket.newInstance(event));
            }
        });
        return this;
    }

    public HttpServer websocketHandler(Consumer<ServerWebSocket> handler) {
        return this.__websocketHandler(handler != null ? handler::accept : null);
    }

    private HttpServer __listen(int port, String host, final Handler<AsyncResult<HttpServer>> listenHandler) {
        this.delegate.listen(port, host, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpServer>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpServer> ar) {
                if (ar.succeeded()) {
                    listenHandler.handle((Object)Future.succeededFuture((Object)HttpServer.newInstance((io.vertx.core.http.HttpServer)ar.result())));
                } else {
                    listenHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<HttpServer> listen(int port, String host) {
        return AsyncResultUni.toUni(handler -> this.__listen(port, host, (Handler<AsyncResult<HttpServer>>)handler));
    }

    public HttpServer listenAndAwait(int port, String host) {
        return (HttpServer)this.listen(port, host).await().indefinitely();
    }

    private HttpServer __listen(SocketAddress address, final Handler<AsyncResult<HttpServer>> listenHandler) {
        this.delegate.listen(address.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpServer>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpServer> ar) {
                if (ar.succeeded()) {
                    listenHandler.handle((Object)Future.succeededFuture((Object)HttpServer.newInstance((io.vertx.core.http.HttpServer)ar.result())));
                } else {
                    listenHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<HttpServer> listen(SocketAddress address) {
        return AsyncResultUni.toUni(handler -> this.__listen(address, (Handler<AsyncResult<HttpServer>>)handler));
    }

    public HttpServer listenAndAwait(SocketAddress address) {
        return (HttpServer)this.listen(address).await().indefinitely();
    }

    private HttpServer __listen(int port, final Handler<AsyncResult<HttpServer>> listenHandler) {
        this.delegate.listen(port, (Handler)new Handler<AsyncResult<io.vertx.core.http.HttpServer>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpServer> ar) {
                if (ar.succeeded()) {
                    listenHandler.handle((Object)Future.succeededFuture((Object)HttpServer.newInstance((io.vertx.core.http.HttpServer)ar.result())));
                } else {
                    listenHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<HttpServer> listen(int port) {
        return AsyncResultUni.toUni(handler -> this.__listen(port, (Handler<AsyncResult<HttpServer>>)handler));
    }

    public HttpServer listenAndAwait(int port) {
        return (HttpServer)this.listen(port).await().indefinitely();
    }

    private HttpServer __listen(final Handler<AsyncResult<HttpServer>> listenHandler) {
        this.delegate.listen((Handler)new Handler<AsyncResult<io.vertx.core.http.HttpServer>>(){

            public void handle(AsyncResult<io.vertx.core.http.HttpServer> ar) {
                if (ar.succeeded()) {
                    listenHandler.handle((Object)Future.succeededFuture((Object)HttpServer.newInstance((io.vertx.core.http.HttpServer)ar.result())));
                } else {
                    listenHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<HttpServer> listen() {
        return AsyncResultUni.toUni(handler -> this.__listen((Handler<AsyncResult<HttpServer>>)handler));
    }

    public HttpServer listenAndAwait() {
        return (HttpServer)this.listen().await().indefinitely();
    }

    private void __close(Handler<AsyncResult<Void>> completionHandler) {
        this.delegate.close(completionHandler);
    }

    public Uni<Void> close() {
        return AsyncResultUni.toUni(handler -> this.__close((Handler<AsyncResult<Void>>)handler));
    }

    public Void closeAndAwait() {
        return (Void)this.close().await().indefinitely();
    }

    public int actualPort() {
        int ret = this.delegate.actualPort();
        return ret;
    }

    public HttpServer listenAndForget() {
        this.delegate.listen();
        return this;
    }

    public HttpServer listenAndForget(int port, String host) {
        this.delegate.listen(port, host);
        return this;
    }

    public HttpServer listenAndForget(int port) {
        this.delegate.listen(port);
        return this;
    }

    public void closeAndForget() {
        this.delegate.close();
    }

    public static HttpServer newInstance(io.vertx.core.http.HttpServer arg) {
        return arg != null ? new HttpServer(arg) : null;
    }
}

