/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.cassandra;

import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.DelegatingHandler;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.cassandra.CassandraClientOptions;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.mutiny.cassandra.CassandraRowStream;
import io.vertx.mutiny.cassandra.ResultSet;
import java.util.List;

@MutinyGen(value=io.vertx.cassandra.CassandraClient.class)
public class CassandraClient {
    public static final TypeArg<CassandraClient> __TYPE_ARG = new TypeArg(obj -> new CassandraClient((io.vertx.cassandra.CassandraClient)obj), CassandraClient::getDelegate);
    private final io.vertx.cassandra.CassandraClient delegate;
    public static final String DEFAULT_SHARED_CLIENT_NAME = "DEFAULT";

    public CassandraClient(io.vertx.cassandra.CassandraClient delegate) {
        this.delegate = delegate;
    }

    public CassandraClient(Object delegate) {
        this.delegate = (io.vertx.cassandra.CassandraClient)delegate;
    }

    CassandraClient() {
        this.delegate = null;
    }

    public io.vertx.cassandra.CassandraClient getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CassandraClient that = (CassandraClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public static CassandraClient create(io.vertx.mutiny.core.Vertx vertx) {
        CassandraClient ret = CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static CassandraClient create(io.vertx.mutiny.core.Vertx vertx, CassandraClientOptions options) {
        CassandraClient ret = CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.create((Vertx)vertx.getDelegate(), (CassandraClientOptions)options));
        return ret;
    }

    public static CassandraClient createShared(io.vertx.mutiny.core.Vertx vertx) {
        CassandraClient ret = CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.createShared((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static CassandraClient createShared(io.vertx.mutiny.core.Vertx vertx, String clientName) {
        CassandraClient ret = CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.createShared((Vertx)vertx.getDelegate(), (String)clientName));
        return ret;
    }

    public static CassandraClient createShared(io.vertx.mutiny.core.Vertx vertx, CassandraClientOptions options) {
        CassandraClient ret = CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.createShared((Vertx)vertx.getDelegate(), (CassandraClientOptions)options));
        return ret;
    }

    public static CassandraClient createShared(io.vertx.mutiny.core.Vertx vertx, String clientName, CassandraClientOptions options) {
        CassandraClient ret = CassandraClient.newInstance(io.vertx.cassandra.CassandraClient.createShared((Vertx)vertx.getDelegate(), (String)clientName, (CassandraClientOptions)options));
        return ret;
    }

    public boolean isConnected() {
        boolean ret = this.delegate.isConnected();
        return ret;
    }

    @CheckReturnValue
    public Uni<ResultSet> execute(String query) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.execute(query, (Handler)new DelegatingHandler(resultHandler, ar -> ar.map(event -> ResultSet.newInstance(event)))));
    }

    public ResultSet executeAndAwait(String query) {
        return (ResultSet)this.execute(query).await().indefinitely();
    }

    @Fluent
    public CassandraClient executeAndForget(String query) {
        this.execute(query).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<CassandraRowStream> queryStream(String sql) {
        return AsyncResultUni.toUni(rowStreamHandler -> this.delegate.queryStream(sql, (Handler)new DelegatingHandler(rowStreamHandler, ar -> ar.map(event -> CassandraRowStream.newInstance(event)))));
    }

    public CassandraRowStream queryStreamAndAwait(String sql) {
        return (CassandraRowStream)this.queryStream(sql).await().indefinitely();
    }

    @Fluent
    public CassandraClient queryStreamAndForget(String sql) {
        this.queryStream(sql).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> close() {
        return AsyncResultUni.toUni(closeHandler -> this.delegate.close(closeHandler));
    }

    public Void closeAndAwait() {
        return (Void)this.close().await().indefinitely();
    }

    @Fluent
    public CassandraClient closeAndForget() {
        this.close().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<List<Row>> executeWithFullFetch(String query) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.executeWithFullFetch(query, resultHandler));
    }

    public List<Row> executeWithFullFetchAndAwait(String query) {
        return (List)this.executeWithFullFetch(query).await().indefinitely();
    }

    public void executeWithFullFetchAndForget(String query) {
        this.executeWithFullFetch(query).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<List<Row>> executeWithFullFetch(Statement statement) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.executeWithFullFetch(statement, resultHandler));
    }

    public List<Row> executeWithFullFetchAndAwait(Statement statement) {
        return (List)this.executeWithFullFetch(statement).await().indefinitely();
    }

    public void executeWithFullFetchAndForget(Statement statement) {
        this.executeWithFullFetch(statement).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<ResultSet> execute(Statement statement) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.execute(statement, (Handler)new DelegatingHandler(resultHandler, ar -> ar.map(event -> ResultSet.newInstance(event)))));
    }

    public ResultSet executeAndAwait(Statement statement) {
        return (ResultSet)this.execute(statement).await().indefinitely();
    }

    @Fluent
    public CassandraClient executeAndForget(Statement statement) {
        this.execute(statement).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<PreparedStatement> prepare(String query) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.prepare(query, resultHandler));
    }

    public PreparedStatement prepareAndAwait(String query) {
        return (PreparedStatement)this.prepare(query).await().indefinitely();
    }

    public void prepareAndForget(String query) {
        this.prepare(query).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<PreparedStatement> prepare(SimpleStatement statement) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.prepare(statement, resultHandler));
    }

    public PreparedStatement prepareAndAwait(SimpleStatement statement) {
        return (PreparedStatement)this.prepare(statement).await().indefinitely();
    }

    public void prepareAndForget(SimpleStatement statement) {
        this.prepare(statement).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<CassandraRowStream> queryStream(Statement statement) {
        return AsyncResultUni.toUni(rowStreamHandler -> this.delegate.queryStream(statement, (Handler)new DelegatingHandler(rowStreamHandler, ar -> ar.map(event -> CassandraRowStream.newInstance(event)))));
    }

    public CassandraRowStream queryStreamAndAwait(Statement statement) {
        return (CassandraRowStream)this.queryStream(statement).await().indefinitely();
    }

    @Fluent
    public CassandraClient queryStreamAndForget(Statement statement) {
        this.queryStream(statement).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Metadata> metadata() {
        return AsyncResultUni.toUni(handler -> this.delegate.metadata(handler));
    }

    public Metadata metadataAndAwait() {
        return (Metadata)this.metadata().await().indefinitely();
    }

    public void metadataAndForget() {
        this.metadata().subscribe().with(UniHelper.NOOP);
    }

    public static CassandraClient newInstance(io.vertx.cassandra.CassandraClient arg) {
        return arg != null ? new CassandraClient(arg) : null;
    }
}

