/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.ext.auth.oauth2;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.OAuth2FlowType;
import io.vertx.ext.auth.oauth2.OAuth2Options;
import io.vertx.mutiny.ext.auth.User;
import io.vertx.mutiny.ext.auth.authentication.AuthenticationProvider;
import io.vertx.mutiny.ext.auth.oauth2.AccessToken;
import io.vertx.mutiny.ext.auth.oauth2.OAuth2RBAC;
import java.util.function.Consumer;

@MutinyGen(value=io.vertx.ext.auth.oauth2.OAuth2Auth.class)
public class OAuth2Auth
extends AuthenticationProvider {
    public static final TypeArg<OAuth2Auth> __TYPE_ARG = new TypeArg(obj -> new OAuth2Auth((io.vertx.ext.auth.oauth2.OAuth2Auth)obj), OAuth2Auth::getDelegate);
    private final io.vertx.ext.auth.oauth2.OAuth2Auth delegate;

    public OAuth2Auth(io.vertx.ext.auth.oauth2.OAuth2Auth delegate) {
        super((io.vertx.ext.auth.authentication.AuthenticationProvider)delegate);
        this.delegate = delegate;
    }

    public OAuth2Auth(Object delegate) {
        super((io.vertx.ext.auth.authentication.AuthenticationProvider)((io.vertx.ext.auth.oauth2.OAuth2Auth)delegate));
        this.delegate = (io.vertx.ext.auth.oauth2.OAuth2Auth)delegate;
    }

    OAuth2Auth() {
        super(null);
        this.delegate = null;
    }

    public io.vertx.ext.auth.oauth2.OAuth2Auth getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        OAuth2Auth that = (OAuth2Auth)((Object)o);
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public static OAuth2Auth create(io.vertx.mutiny.core.Vertx vertx) {
        OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.OAuth2Auth.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static OAuth2Auth create(io.vertx.mutiny.core.Vertx vertx, OAuth2Options config) {
        OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.OAuth2Auth.create((Vertx)vertx.getDelegate(), (OAuth2Options)config));
        return ret;
    }

    public Uni<Void> jWKSet() {
        return AsyncResultUni.toUni(handler -> this.delegate.jWKSet(handler));
    }

    public Void jWKSetAndAwait() {
        return (Void)this.jWKSet().await().indefinitely();
    }

    @Fluent
    public OAuth2Auth jWKSetAndForget() {
        this.jWKSet().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Fluent
    private OAuth2Auth __missingKeyHandler(Handler<String> handler) {
        this.delegate.missingKeyHandler(handler);
        return this;
    }

    public OAuth2Auth missingKeyHandler(Consumer<String> handler) {
        return this.__missingKeyHandler(handler != null ? handler::accept : null);
    }

    public String authorizeURL(JsonObject params) {
        String ret = this.delegate.authorizeURL(params);
        return ret;
    }

    public Uni<User> refresh(User user) {
        return AsyncResultUni.toUni(handler -> this.delegate.refresh(user.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.ext.auth.User>>(){

            public void handle(AsyncResult<io.vertx.ext.auth.User> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)User.newInstance((io.vertx.ext.auth.User)((io.vertx.ext.auth.User)ar.result()))));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public User refreshAndAwait(User user) {
        return (User)this.refresh(user).await().indefinitely();
    }

    @Fluent
    public OAuth2Auth refreshAndForget(User user) {
        this.refresh(user).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public Uni<Void> revoke(User user, String tokenType) {
        return AsyncResultUni.toUni(handler -> this.delegate.revoke(user.getDelegate(), tokenType, handler));
    }

    public Void revokeAndAwait(User user, String tokenType) {
        return (Void)this.revoke(user, tokenType).await().indefinitely();
    }

    @Fluent
    public OAuth2Auth revokeAndForget(User user, String tokenType) {
        this.revoke(user, tokenType).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public Uni<Void> revoke(User user) {
        return AsyncResultUni.toUni(handler -> this.delegate.revoke(user.getDelegate(), handler));
    }

    public Void revokeAndAwait(User user) {
        return (Void)this.revoke(user).await().indefinitely();
    }

    @Fluent
    public OAuth2Auth revokeAndForget(User user) {
        this.revoke(user).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public Uni<JsonObject> userInfo(User user) {
        return AsyncResultUni.toUni(handler -> this.delegate.userInfo(user.getDelegate(), handler));
    }

    public JsonObject userInfoAndAwait(User user) {
        return (JsonObject)this.userInfo(user).await().indefinitely();
    }

    @Fluent
    public OAuth2Auth userInfoAndForget(User user) {
        this.userInfo(user).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public String endSessionURL(User user, JsonObject params) {
        String ret = this.delegate.endSessionURL(user.getDelegate(), params);
        return ret;
    }

    public String endSessionURL(User user) {
        String ret = this.delegate.endSessionURL(user.getDelegate());
        return ret;
    }

    @Deprecated
    public Uni<AccessToken> decodeToken(String token) {
        return AsyncResultUni.toUni(handler -> this.delegate.decodeToken(token, (Handler)new Handler<AsyncResult<io.vertx.ext.auth.oauth2.AccessToken>>(){

            public void handle(AsyncResult<io.vertx.ext.auth.oauth2.AccessToken> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)((Object)AccessToken.newInstance((io.vertx.ext.auth.oauth2.AccessToken)ar.result()))));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    @Deprecated
    public AccessToken decodeTokenAndAwait(String token) {
        return (AccessToken)((Object)this.decodeToken(token).await().indefinitely());
    }

    @Deprecated
    @Fluent
    public OAuth2Auth decodeTokenAndForget(String token) {
        this.decodeToken(token).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Deprecated
    public Uni<AccessToken> introspectToken(String token) {
        return AsyncResultUni.toUni(handler -> this.delegate.introspectToken(token, (Handler)new Handler<AsyncResult<io.vertx.ext.auth.oauth2.AccessToken>>(){

            public void handle(AsyncResult<io.vertx.ext.auth.oauth2.AccessToken> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)((Object)AccessToken.newInstance((io.vertx.ext.auth.oauth2.AccessToken)ar.result()))));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    @Deprecated
    public AccessToken introspectTokenAndAwait(String token) {
        return (AccessToken)((Object)this.introspectToken(token).await().indefinitely());
    }

    @Deprecated
    @Fluent
    public OAuth2Auth introspectTokenAndForget(String token) {
        this.introspectToken(token).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Deprecated
    public Uni<AccessToken> introspectToken(String token, String tokenType) {
        return AsyncResultUni.toUni(handler -> this.delegate.introspectToken(token, tokenType, (Handler)new Handler<AsyncResult<io.vertx.ext.auth.oauth2.AccessToken>>(){

            public void handle(AsyncResult<io.vertx.ext.auth.oauth2.AccessToken> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)((Object)AccessToken.newInstance((io.vertx.ext.auth.oauth2.AccessToken)ar.result()))));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    @Deprecated
    public AccessToken introspectTokenAndAwait(String token, String tokenType) {
        return (AccessToken)((Object)this.introspectToken(token, tokenType).await().indefinitely());
    }

    @Deprecated
    @Fluent
    public OAuth2Auth introspectTokenAndForget(String token, String tokenType) {
        this.introspectToken(token, tokenType).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Deprecated
    public OAuth2FlowType getFlowType() {
        OAuth2FlowType ret = this.delegate.getFlowType();
        return ret;
    }

    @Deprecated
    public Uni<Void> loadJWK() {
        return AsyncResultUni.toUni(handler -> this.delegate.loadJWK(handler));
    }

    @Deprecated
    public Void loadJWKAndAwait() {
        return (Void)this.loadJWK().await().indefinitely();
    }

    @Deprecated
    @Fluent
    public OAuth2Auth loadJWKAndForget() {
        this.loadJWK().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Deprecated
    @Fluent
    public OAuth2Auth rbacHandler(OAuth2RBAC rbac) {
        this.delegate.rbacHandler(rbac.getDelegate());
        return this;
    }

    public static OAuth2Auth newInstance(io.vertx.ext.auth.oauth2.OAuth2Auth arg) {
        return arg != null ? new OAuth2Auth(arg) : null;
    }
}

