/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.ext.auth.oauth2;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.DelegatingConsumerHandler;
import io.smallrye.mutiny.vertx.DelegatingHandler;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.OAuth2Options;
import io.vertx.mutiny.ext.auth.User;
import io.vertx.mutiny.ext.auth.authentication.AuthenticationProvider;
import java.util.function.Consumer;

@MutinyGen(value=io.vertx.ext.auth.oauth2.OAuth2Auth.class)
public class OAuth2Auth
extends AuthenticationProvider {
    public static final TypeArg<OAuth2Auth> __TYPE_ARG = new TypeArg(obj -> new OAuth2Auth((io.vertx.ext.auth.oauth2.OAuth2Auth)obj), OAuth2Auth::getDelegate);
    private final io.vertx.ext.auth.oauth2.OAuth2Auth delegate;

    public OAuth2Auth(io.vertx.ext.auth.oauth2.OAuth2Auth delegate) {
        super((io.vertx.ext.auth.authentication.AuthenticationProvider)delegate);
        this.delegate = delegate;
    }

    public OAuth2Auth(Object delegate) {
        super((io.vertx.ext.auth.authentication.AuthenticationProvider)((io.vertx.ext.auth.oauth2.OAuth2Auth)delegate));
        this.delegate = (io.vertx.ext.auth.oauth2.OAuth2Auth)delegate;
    }

    OAuth2Auth() {
        super(null);
        this.delegate = null;
    }

    public io.vertx.ext.auth.oauth2.OAuth2Auth getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        OAuth2Auth that = (OAuth2Auth)((Object)o);
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public static OAuth2Auth create(io.vertx.mutiny.core.Vertx vertx) {
        OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.OAuth2Auth.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static OAuth2Auth create(io.vertx.mutiny.core.Vertx vertx, OAuth2Options config) {
        OAuth2Auth ret = OAuth2Auth.newInstance(io.vertx.ext.auth.oauth2.OAuth2Auth.create((Vertx)vertx.getDelegate(), (OAuth2Options)config));
        return ret;
    }

    @CheckReturnValue
    public Uni<Void> jWKSet() {
        return AsyncResultUni.toUni(handler -> this.delegate.jWKSet(handler));
    }

    public Void jWKSetAndAwait() {
        return (Void)this.jWKSet().await().indefinitely();
    }

    @Fluent
    public OAuth2Auth jWKSetAndForget() {
        this.jWKSet().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Fluent
    private OAuth2Auth __missingKeyHandler(Handler<String> handler) {
        this.delegate.missingKeyHandler(handler);
        return this;
    }

    public OAuth2Auth missingKeyHandler(Consumer<String> handler) {
        return this.__missingKeyHandler((Handler<String>)(handler != null ? new DelegatingConsumerHandler(handler) : null));
    }

    public String authorizeURL(JsonObject params) {
        String ret = this.delegate.authorizeURL(params);
        return ret;
    }

    @CheckReturnValue
    public Uni<User> refresh(User user) {
        return AsyncResultUni.toUni(handler -> this.delegate.refresh(user.getDelegate(), (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> User.newInstance((io.vertx.ext.auth.User)event)))));
    }

    public User refreshAndAwait(User user) {
        return (User)this.refresh(user).await().indefinitely();
    }

    @Fluent
    public OAuth2Auth refreshAndForget(User user) {
        this.refresh(user).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> revoke(User user, String tokenType) {
        return AsyncResultUni.toUni(handler -> this.delegate.revoke(user.getDelegate(), tokenType, handler));
    }

    public Void revokeAndAwait(User user, String tokenType) {
        return (Void)this.revoke(user, tokenType).await().indefinitely();
    }

    @Fluent
    public OAuth2Auth revokeAndForget(User user, String tokenType) {
        this.revoke(user, tokenType).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> revoke(User user) {
        return AsyncResultUni.toUni(handler -> this.delegate.revoke(user.getDelegate(), handler));
    }

    public Void revokeAndAwait(User user) {
        return (Void)this.revoke(user).await().indefinitely();
    }

    @Fluent
    public OAuth2Auth revokeAndForget(User user) {
        this.revoke(user).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<JsonObject> userInfo(User user) {
        return AsyncResultUni.toUni(handler -> this.delegate.userInfo(user.getDelegate(), handler));
    }

    public JsonObject userInfoAndAwait(User user) {
        return (JsonObject)this.userInfo(user).await().indefinitely();
    }

    @Fluent
    public OAuth2Auth userInfoAndForget(User user) {
        this.userInfo(user).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public String endSessionURL(User user, JsonObject params) {
        String ret = this.delegate.endSessionURL(user.getDelegate(), params);
        return ret;
    }

    public String endSessionURL(User user) {
        String ret = this.delegate.endSessionURL(user.getDelegate());
        return ret;
    }

    public void close() {
        this.delegate.close();
    }

    public static OAuth2Auth newInstance(io.vertx.ext.auth.oauth2.OAuth2Auth arg) {
        return arg != null ? new OAuth2Auth(arg) : null;
    }
}

