/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.ext.auth.oauth2.providers;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.auth.oauth2.OAuth2Options;
import io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth;

@MutinyGen(value=io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth.class)
public class OpenIDConnectAuth {
    public static final TypeArg<OpenIDConnectAuth> __TYPE_ARG = new TypeArg(obj -> new OpenIDConnectAuth((io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth)obj), OpenIDConnectAuth::getDelegate);
    private final io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth delegate;

    public OpenIDConnectAuth(io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth delegate) {
        this.delegate = delegate;
    }

    public OpenIDConnectAuth(Object delegate) {
        this.delegate = (io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth)delegate;
    }

    OpenIDConnectAuth() {
        this.delegate = null;
    }

    public io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenIDConnectAuth that = (OpenIDConnectAuth)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @CheckReturnValue
    public static Uni<OAuth2Auth> discover(io.vertx.mutiny.core.Vertx vertx, OAuth2Options config) {
        return AsyncResultUni.toUni(handler -> io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth.discover((Vertx)vertx.getDelegate(), (OAuth2Options)config, (Handler)new Handler<AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Auth>>(){

            public void handle(AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Auth> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)((Object)OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)ar.result()))));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public static OAuth2Auth discoverAndAwait(io.vertx.mutiny.core.Vertx vertx, OAuth2Options config) {
        return (OAuth2Auth)((Object)OpenIDConnectAuth.discover(vertx, config).await().indefinitely());
    }

    public static void discoverAndForget(io.vertx.mutiny.core.Vertx vertx, OAuth2Options config) {
        OpenIDConnectAuth.discover(vertx, config).subscribe().with(UniHelper.NOOP);
    }

    public static OpenIDConnectAuth newInstance(io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth arg) {
        return arg != null ? new OpenIDConnectAuth(arg) : null;
    }
}

