/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.helpers;

import io.smallrye.mutiny.helpers.Subscriptions;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class HalfSerializer {
    private HalfSerializer() {
    }

    public static <T> void onNext(Flow.Subscriber<? super T> subscriber, T item, AtomicInteger wip, AtomicReference<Throwable> container) {
        if (wip.compareAndSet(0, 1)) {
            subscriber.onNext(item);
            if (wip.decrementAndGet() != 0) {
                Throwable ex = Subscriptions.terminate(container);
                if (ex != null) {
                    subscriber.onError(ex);
                } else {
                    subscriber.onComplete();
                }
            }
        } else {
            IllegalStateException err = new IllegalStateException("HalfSerializer has detected concurrent onNext(item) signals which is not permitted by the Reactive Streams protocol");
            HalfSerializer.onError(subscriber, err, wip, container);
        }
    }

    public static void onError(Flow.Subscriber<?> subscriber, Throwable failure, AtomicInteger wip, AtomicReference<Throwable> container) {
        if (Subscriptions.addFailure(container, failure) && wip.getAndIncrement() == 0) {
            subscriber.onError(Subscriptions.terminate(container));
        }
    }

    public static void onComplete(Flow.Subscriber<?> subscriber, AtomicInteger wip, AtomicReference<Throwable> container) {
        if (wip.getAndIncrement() == 0) {
            Throwable ex = Subscriptions.terminate(container);
            if (ex != null) {
                subscriber.onError(ex);
            } else {
                subscriber.onComplete();
            }
        }
    }
}

