/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.UniDelegatingSubscriber;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.operators.UniSerializedSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class UniDelayOnItem<T>
extends UniOperator<T, T> {
    private final Duration duration;
    private final ScheduledExecutorService executor;

    public UniDelayOnItem(Uni<T> upstream, Duration duration, ScheduledExecutorService executor) {
        super(ParameterValidation.nonNull(upstream, "upstream"));
        this.duration = ParameterValidation.validate(duration, "duration");
        this.executor = ParameterValidation.nonNull(executor, "executor");
    }

    @Override
    protected void subscribing(UniSerializedSubscriber<? super T> subscriber) {
        final AtomicReference holder = new AtomicReference();
        final AtomicReference reference = new AtomicReference();
        AbstractUni.subscribe(this.upstream(), new UniDelegatingSubscriber<T, T>(subscriber){

            @Override
            public void onSubscribe(UniSubscription subscription) {
                if (reference.compareAndSet(null, subscription)) {
                    super.onSubscribe(() -> {
                        if (reference.compareAndSet(subscription, EmptyUniSubscription.CANCELLED)) {
                            subscription.cancel();
                            ScheduledFuture future = holder.getAndSet(null);
                            if (future != null) {
                                future.cancel(true);
                            }
                        }
                    });
                }
            }

            @Override
            public void onItem(T item) {
                if (reference.get() != EmptyUniSubscription.CANCELLED) {
                    try {
                        ScheduledFuture<?> future = UniDelayOnItem.this.executor.schedule(() -> super.onItem(item), UniDelayOnItem.this.duration.toMillis(), TimeUnit.MILLISECONDS);
                        holder.set(future);
                    }
                    catch (RuntimeException e) {
                        super.onFailure(e);
                    }
                }
            }
        });
    }
}

