/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.UniDelegatingSubscriber;
import io.smallrye.mutiny.operators.UniOnItemFlatMap;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.operators.UniSerializedSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

public class UniFlatMapCompletionStageOnItem<I, O>
extends UniOperator<I, O> {
    private final Function<? super I, ? extends CompletionStage<? extends O>> mapper;

    public UniFlatMapCompletionStageOnItem(Uni<I> upstream, Function<? super I, ? extends CompletionStage<? extends O>> mapper) {
        super(ParameterValidation.nonNull(upstream, "upstream"));
        this.mapper = ParameterValidation.nonNull(mapper, "mapper");
    }

    private static <I, O> void invokeAndSubstitute(Function<? super I, ? extends CompletionStage<? extends O>> mapper, I input, UniSerializedSubscriber<? super O> subscriber, final UniOnItemFlatMap.FlatMapSubscription flatMapSubscription) {
        CompletionStage<? extends O> outcome;
        try {
            outcome = mapper.apply(input);
        }
        catch (Throwable e) {
            subscriber.onFailure(e);
            return;
        }
        if (outcome == null) {
            subscriber.onFailure(new NullPointerException("The mapper returned `null`"));
        } else {
            UniDelegatingSubscriber delegate = new UniDelegatingSubscriber<O, O>(subscriber){

                @Override
                public void onSubscribe(UniSubscription secondSubscription) {
                    flatMapSubscription.replace(secondSubscription);
                }
            };
            Uni.createFrom().completionStage(outcome).subscribe().withSubscriber(delegate);
        }
    }

    @Override
    protected void subscribing(final UniSerializedSubscriber<? super O> subscriber) {
        final UniOnItemFlatMap.FlatMapSubscription flatMapSubscription = new UniOnItemFlatMap.FlatMapSubscription();
        this.upstream().subscribe().withSubscriber(new UniDelegatingSubscriber<I, O>(subscriber){

            @Override
            public void onSubscribe(UniSubscription subscription) {
                flatMapSubscription.setInitialUpstream(subscription);
                subscriber.onSubscribe(flatMapSubscription);
            }

            @Override
            public void onItem(I item) {
                UniFlatMapCompletionStageOnItem.invokeAndSubstitute(UniFlatMapCompletionStageOnItem.this.mapper, item, subscriber, flatMapSubscription);
            }
        });
    }
}

