/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.UniCallbackSubscriber;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.UniSerializedSubscriber;
import io.smallrye.mutiny.operators.UniSubscribeToCompletionStage;
import io.smallrye.mutiny.subscription.Cancellable;
import io.smallrye.mutiny.subscription.UniSubscriber;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class UniSubscribe<T> {
    private final AbstractUni<T> upstream;

    public UniSubscribe(AbstractUni<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    public <S extends UniSubscriber<? super T>> S withSubscriber(S subscriber) {
        UniSerializedSubscriber.subscribe(this.upstream, ParameterValidation.nonNull(subscriber, "subscriber"));
        return subscriber;
    }

    public Cancellable with(Consumer<? super T> onItemCallback, Consumer<? super Throwable> onFailureCallback) {
        UniCallbackSubscriber<? super T> subscriber = new UniCallbackSubscriber<T>(ParameterValidation.nonNull(onItemCallback, "onItemCallback"), ParameterValidation.nonNull(onFailureCallback, "onFailureCallback"));
        this.withSubscriber(subscriber);
        return subscriber;
    }

    public Cancellable with(Consumer<? super T> onItemCallback) {
        UniCallbackSubscriber<? super T> subscriber = new UniCallbackSubscriber<T>(ParameterValidation.nonNull(onItemCallback, "onItemCallback"), f -> {});
        this.withSubscriber(subscriber);
        return subscriber;
    }

    public CompletableFuture<T> asCompletionStage() {
        return UniSubscribeToCompletionStage.subscribe(this.upstream);
    }
}

