/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.converters.MultiConverter;
import io.smallrye.mutiny.groups.MultiResource;
import io.smallrye.mutiny.groups.MultiTimePeriod;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.AbstractMulti;
import io.smallrye.mutiny.operators.multi.builders.CollectionBasedMulti;
import io.smallrye.mutiny.operators.multi.builders.DeferredMulti;
import io.smallrye.mutiny.operators.multi.builders.EmitterBasedMulti;
import io.smallrye.mutiny.operators.multi.builders.EmptyMulti;
import io.smallrye.mutiny.operators.multi.builders.FailedMulti;
import io.smallrye.mutiny.operators.multi.builders.IterableBasedMulti;
import io.smallrye.mutiny.operators.multi.builders.NeverMulti;
import io.smallrye.mutiny.operators.multi.builders.StreamBasedMulti;
import io.smallrye.mutiny.subscription.BackPressureStrategy;
import io.smallrye.mutiny.subscription.MultiEmitter;
import io.smallrye.mutiny.subscription.SafeSubscriber;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public class MultiCreate {
    public static final MultiCreate INSTANCE = new MultiCreate();

    private MultiCreate() {
    }

    public <I, T> Multi<T> converter(MultiConverter<I, T> converter, I instance) {
        return Infrastructure.onMultiCreation(converter.from(instance));
    }

    public <T> Multi<T> completionStage(CompletionStage<? extends T> stage) {
        CompletionStage actual = ParameterValidation.nonNull(stage, "stage");
        return this.completionStage(() -> actual);
    }

    public <T> Multi<T> completionStage(Supplier<? extends CompletionStage<? extends T>> supplier) {
        ParameterValidation.nonNull(supplier, "supplier");
        return this.emitter(emitter -> {
            CompletionStage stage;
            try {
                stage = (CompletionStage)supplier.get();
            }
            catch (Throwable e) {
                emitter.fail(e);
                return;
            }
            if (stage == null) {
                throw new NullPointerException("The supplier returned `null`");
            }
            emitter.onTermination(() -> stage.toCompletableFuture().cancel(false));
            stage.whenComplete((r, f) -> {
                if (f != null) {
                    emitter.fail((Throwable)f);
                } else if (r != null) {
                    emitter.emit(r);
                }
                emitter.complete();
            });
        }, BackPressureStrategy.LATEST);
    }

    public <T> Multi<T> publisher(Publisher<T> publisher) {
        final Publisher<T> actual = ParameterValidation.nonNull(publisher, "publisher");
        return Infrastructure.onMultiCreation(new AbstractMulti<T>(){

            @Override
            public void subscribe(Subscriber<? super T> subscriber) {
                actual.subscribe(new SafeSubscriber(subscriber));
            }
        });
    }

    public <T> Multi<T> uni(Uni<T> uni) {
        return ParameterValidation.nonNull(uni, "uni").toMulti();
    }

    public <T> Multi<T> item(Supplier<? extends T> supplier) {
        Supplier actual = ParameterValidation.nonNull(supplier, "supplier");
        return this.emitter(emitter -> {
            Object item;
            try {
                item = actual.get();
            }
            catch (RuntimeException e) {
                emitter.fail(e);
                return;
            }
            if (item != null) {
                emitter.emit(item);
            }
            emitter.complete();
        });
    }

    public <T> Multi<T> items(Supplier<? extends Stream<? extends T>> supplier) {
        Supplier<? extends Stream<? extends T>> actual = ParameterValidation.nonNull(supplier, "supplier");
        return new StreamBasedMulti(actual);
    }

    public <T> Multi<T> item(T item) {
        return this.item((T)((Supplier<Object>)() -> item));
    }

    @SafeVarargs
    public final <T> Multi<T> items(T ... items) {
        return Infrastructure.onMultiCreation(new CollectionBasedMulti<T>(ParameterValidation.nonNull(items, "items")));
    }

    public <T> Multi<T> iterable(Iterable<T> iterable) {
        return Infrastructure.onMultiCreation(new IterableBasedMulti<T>(ParameterValidation.nonNull(iterable, "produceIterable")));
    }

    public <T> Multi<T> items(Stream<T> items) {
        Stream stream = ParameterValidation.nonNull(items, "items");
        return this.items(() -> stream);
    }

    public <T> Multi<T> optional(Optional<T> optional) {
        Optional actual = ParameterValidation.nonNull(optional, "optional");
        return this.item((T)((Supplier<Object>)() -> actual.orElse(null)));
    }

    public <T> Multi<T> optional(Supplier<Optional<T>> supplier) {
        Supplier actual = ParameterValidation.nonNull(supplier, "supplier");
        return this.item((T)((Supplier<Object>)() -> ((Optional)actual.get()).orElse(null)));
    }

    public <T> Multi<T> emitter(Consumer<MultiEmitter<? super T>> consumer) {
        return this.emitter(consumer, BackPressureStrategy.BUFFER);
    }

    public <T> Multi<T> emitter(Consumer<MultiEmitter<? super T>> consumer, BackPressureStrategy strategy) {
        Consumer<MultiEmitter<? super T>> actual = ParameterValidation.nonNull(consumer, "consumer");
        return Infrastructure.onMultiCreation(new EmitterBasedMulti<T>(actual, ParameterValidation.nonNull(strategy, "strategy")));
    }

    public <T> Multi<T> deferred(Supplier<? extends Multi<? extends T>> supplier) {
        return Infrastructure.onMultiCreation(new DeferredMulti(ParameterValidation.nonNull(supplier, "supplier")));
    }

    public <T> Multi<T> failure(Throwable failure) {
        Throwable exception = ParameterValidation.nonNull(failure, "failure");
        return this.failure(() -> exception);
    }

    public <T> Multi<T> failure(Supplier<Throwable> supplier) {
        return Infrastructure.onMultiCreation(new FailedMulti(supplier));
    }

    public <T> Multi<T> nothing() {
        return Infrastructure.onMultiCreation(NeverMulti.never());
    }

    public <T> Multi<T> empty() {
        return Infrastructure.onMultiCreation(EmptyMulti.empty());
    }

    public MultiTimePeriod ticks() {
        return new MultiTimePeriod();
    }

    public Multi<Integer> range(int startInclusive, int endExclusive) {
        if (endExclusive <= startInclusive) {
            throw new IllegalArgumentException("end must be greater than start");
        }
        return Multi.createFrom().iterable(() -> IntStream.range(startInclusive, endExclusive).iterator());
    }

    public <R, I> MultiResource<R, I> resource(Supplier<? extends R> resourceSupplier, Function<? super R, ? extends Publisher<I>> streamSupplier) {
        return new MultiResource(ParameterValidation.nonNull(resourceSupplier, "resourceSupplier"), ParameterValidation.nonNull(streamSupplier, "streamSupplier"));
    }
}

