/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi.overflow;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import org.reactivestreams.Subscription;

public class MultiOnOverflowDropItemsOp<T>
extends AbstractMultiOperator<T, T> {
    private final Consumer<T> dropConsumer;
    private final Function<T, Uni<?>> dropUniMapper;

    public MultiOnOverflowDropItemsOp(Multi<? extends T> upstream, Consumer<T> dropConsumer, Function<T, Uni<?>> dropUniMapper) {
        super(upstream);
        this.dropConsumer = dropConsumer;
        this.dropUniMapper = dropUniMapper;
    }

    public MultiOnOverflowDropItemsOp(Multi<T> upstream) {
        this(upstream, null, null);
    }

    public MultiOnOverflowDropItemsOp(Multi<T> upstream, Consumer<T> dropConsumer) {
        this(upstream, dropConsumer, null);
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> downstream) {
        this.upstream.subscribe().withSubscriber(new MultiOnOverflowDropItemsProcessor(downstream));
    }

    class MultiOnOverflowDropItemsProcessor
    extends MultiOperatorProcessor<T, T> {
        private final AtomicLong requested;

        MultiOnOverflowDropItemsProcessor(MultiSubscriber<? super T> downstream) {
            super(downstream);
            this.requested = new AtomicLong();
        }

        @Override
        public void onSubscribe(Subscription subscription) {
            if (this.upstream.compareAndSet(null, subscription)) {
                this.downstream.onSubscribe(this);
                ((Subscription)this.upstream.get()).request(Long.MAX_VALUE);
            } else {
                subscription.cancel();
            }
        }

        @Override
        public void onItem(T item) {
            if (this.isDone()) {
                return;
            }
            long req = this.requested.get();
            if (req != 0L) {
                this.downstream.onItem(item);
                Subscriptions.subtract(this.requested, 1L);
            } else if (MultiOnOverflowDropItemsOp.this.dropConsumer != null) {
                this.notifyOnOverflowInvoke(item);
            } else if (MultiOnOverflowDropItemsOp.this.dropUniMapper != null) {
                this.notifyOnOverflowCall(item);
            }
        }

        private void notifyOnOverflowInvoke(T item) {
            try {
                MultiOnOverflowDropItemsOp.this.dropConsumer.accept(item);
            }
            catch (Throwable e) {
                super.onFailure(e);
            }
        }

        private void notifyOnOverflowCall(T item) {
            try {
                Uni uni = (Uni)ParameterValidation.nonNull(MultiOnOverflowDropItemsOp.this.dropUniMapper.apply(item), "uni");
                uni.subscribe().with(ignored -> {}, x$0 -> super.onFailure((Throwable)x$0));
            }
            catch (Throwable failure) {
                super.onFailure(failure);
            }
        }

        @Override
        public void request(long n) {
            if (n > 0L) {
                Subscriptions.add(this.requested, n);
            }
        }
    }
}

