/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.UniDelegatingSubscriber;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.function.Supplier;

public class UniOnCancellationCall<I>
extends UniOperator<I, I> {
    private final Supplier<Uni<?>> supplier;

    public UniOnCancellationCall(Uni<? extends I> upstream, Supplier<Uni<?>> supplier) {
        super(ParameterValidation.nonNull(upstream, "upstream"));
        this.supplier = ParameterValidation.nonNull(supplier, "supplier");
    }

    @Override
    protected void subscribing(final UniSubscriber<? super I> subscriber) {
        this.upstream().subscribe().withSubscriber(new UniDelegatingSubscriber<I, I>(subscriber){

            @Override
            public void onSubscribe(final UniSubscription subscription) {
                subscriber.onSubscribe(new UniSubscription(){

                    @Override
                    public void cancel() {
                        this.execute().subscribe().with(ignoredItem -> subscription.cancel(), ignoredException -> {
                            Infrastructure.handleDroppedException(ignoredException);
                            subscription.cancel();
                        });
                    }

                    private Uni<?> execute() {
                        try {
                            return (Uni)ParameterValidation.nonNull(UniOnCancellationCall.this.supplier.get(), "uni");
                        }
                        catch (Throwable err) {
                            return Uni.createFrom().failure(err);
                        }
                    }
                });
            }
        });
    }
}

