/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import io.smallrye.mutiny.subscription.SerializedSubscriber;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class MultiTakeUntilOtherOp<T, U>
extends AbstractMultiOperator<T, T> {
    private final Publisher<U> other;

    public MultiTakeUntilOtherOp(Multi<? extends T> upstream, Publisher<U> other) {
        super(upstream);
        this.other = ParameterValidation.nonNull(other, "other");
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> actual) {
        TakeUntilMainProcessor<? super T> mainSubscriber = new TakeUntilMainProcessor<T>(actual);
        TakeUntilOtherSubscriber otherSubscriber = new TakeUntilOtherSubscriber(mainSubscriber);
        this.other.subscribe(Infrastructure.onMultiSubscription(this.other, otherSubscriber));
        this.upstream.subscribe(Infrastructure.onMultiSubscription(this.upstream, mainSubscriber));
    }

    public static final class TakeUntilMainProcessor<T>
    extends MultiOperatorProcessor<T, T> {
        private final AtomicReference<Subscription> other = new AtomicReference();

        public TakeUntilMainProcessor(Subscriber<? super T> downstream) {
            super(new SerializedSubscriber<T>(downstream));
        }

        void setOtherSubscription(Subscription s) {
            if (this.other.compareAndSet(null, s)) {
                s.request(1L);
            } else {
                s.cancel();
            }
        }

        @Override
        public void cancel() {
            super.cancel();
            Subscriptions.cancel(this.other);
        }

        @Override
        public void onItem(T t) {
            if (!this.isDone()) {
                this.downstream.onItem(t);
            }
        }

        @Override
        public void onFailure(Throwable failure) {
            super.onFailure(failure);
            Subscriptions.cancel(this.other);
        }

        public void onOtherFailure(Throwable failure) {
            super.onFailure(failure);
        }

        @Override
        public void onCompletion() {
            super.onCompletion();
            Subscriptions.cancel(this.other);
        }

        public void onOtherCompletion() {
            super.onCompletion();
        }
    }

    public static final class TakeUntilOtherSubscriber<U>
    implements MultiSubscriber<U> {
        final TakeUntilMainProcessor<?> main;
        boolean once;

        public TakeUntilOtherSubscriber(TakeUntilMainProcessor<?> main) {
            this.main = main;
        }

        public void onSubscribe(Subscription s) {
            this.main.setOtherSubscription(s);
        }

        @Override
        public void onItem(U t) {
            Objects.requireNonNull(t);
            this.onCompletion();
        }

        @Override
        public void onFailure(Throwable t) {
            Objects.requireNonNull(t);
            if (this.once) {
                return;
            }
            this.once = true;
            this.main.onOtherFailure(t);
        }

        @Override
        public void onCompletion() {
            if (this.once) {
                return;
            }
            this.once = true;
            this.main.onOtherCompletion();
        }
    }
}

