/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni.builders;

import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.subscription.UniSubscriber;
import java.util.function.Function;
import java.util.function.Supplier;

public class StateSuppliedtemUni<T, S>
extends AbstractUni<T> {
    private final Supplier<S> stateSupplier;
    private final Function<S, ? extends T> mapper;
    private volatile boolean supplied = false;
    private volatile S state = null;

    public StateSuppliedtemUni(Supplier<S> stateSupplier, Function<S, ? extends T> mapper) {
        this.stateSupplier = stateSupplier;
        this.mapper = mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void subscribing(UniSubscriber<? super T> subscriber) {
        subscriber.onSubscribe(EmptyUniSubscription.CANCELLED);
        StateSuppliedtemUni stateSuppliedtemUni = this;
        synchronized (stateSuppliedtemUni) {
            if (!this.supplied) {
                this.supplied = true;
                try {
                    this.state = this.stateSupplier.get();
                    if (this.state == null) {
                        subscriber.onFailure(new NullPointerException("The supplier returned `null`"));
                        return;
                    }
                }
                catch (Throwable err) {
                    subscriber.onFailure(err);
                    return;
                }
            }
        }
        if (this.state == null) {
            subscriber.onFailure(new IllegalStateException("Invalid shared state"));
        } else {
            try {
                subscriber.onItem(this.mapper.apply(this.state));
            }
            catch (Throwable err) {
                subscriber.onFailure(err);
            }
        }
    }
}

