/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi.multicast;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.helpers.queues.SpscArrayQueue;
import io.smallrye.mutiny.operators.multi.multicast.ConnectableMulti;
import io.smallrye.mutiny.operators.multi.multicast.ConnectableMultiConnection;
import io.smallrye.mutiny.subscription.BackPressureFailure;
import io.smallrye.mutiny.subscription.Cancellable;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class MultiPublishOp<T>
extends ConnectableMulti<T> {
    private static final long CANCELLED = Long.MIN_VALUE;
    private final AtomicReference<PublishSubscriber<T>> current;
    private final int bufferSize;
    private final Publisher<T> onSubscribe;

    public static <T> ConnectableMulti<T> create(Multi<T> upstream) {
        AtomicReference curr = new AtomicReference();
        InnerPublisher onSubscribe = new InnerPublisher(curr, 128);
        return new MultiPublishOp(onSubscribe, upstream, curr, 128);
    }

    private MultiPublishOp(Publisher<T> onSubscribe, Multi<T> upstream, AtomicReference<PublishSubscriber<T>> current, int bufferSize) {
        super(upstream);
        this.onSubscribe = onSubscribe;
        this.current = current;
        this.bufferSize = bufferSize;
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> s) {
        this.onSubscribe.subscribe(s);
    }

    @Override
    public void connect(ConnectableMultiConnection connection) {
        boolean doConnect;
        PublishSubscriber<T> ps;
        while ((ps = this.current.get()) == null || ((PublishSubscriber)ps).cancelled.get()) {
            PublishSubscriber<T> u = new PublishSubscriber<T>(this.current, this.bufferSize);
            if (!this.current.compareAndSet(ps, u)) continue;
            ps = u;
            break;
        }
        boolean bl = doConnect = !ps.shouldConnect.get() && ps.shouldConnect.compareAndSet(false, true);
        if (connection != null) {
            connection.accept(ps);
        }
        if (doConnect) {
            this.upstream.subscribe(ps);
        }
    }

    static final class InnerPublisher<T>
    implements Publisher<T> {
        private final AtomicReference<PublishSubscriber<T>> curr;
        private final int bufferSize;

        InnerPublisher(AtomicReference<PublishSubscriber<T>> curr, int bufferSize) {
            this.curr = curr;
            this.bufferSize = bufferSize;
        }

        public void subscribe(Subscriber<? super T> child) {
            PublishSubscriber<Object> r;
            InnerSubscriber<? super T> inner = new InnerSubscriber<T>(child);
            child.onSubscribe(inner);
            while (true) {
                if ((r = this.curr.get()) == null || ((PublishSubscriber)r).cancelled.get()) {
                    PublishSubscriber<T> u = new PublishSubscriber<T>(this.curr, this.bufferSize);
                    if (!this.curr.compareAndSet(r, u)) continue;
                    r = u;
                }
                if (r.add(inner)) break;
            }
            if (((InnerSubscriber)inner).requested.get() == Long.MIN_VALUE) {
                r.remove(inner);
            } else {
                ((InnerSubscriber)inner).parent.set(r);
            }
            r.drain();
        }
    }

    static final class InnerSubscriber<T>
    implements Subscription {
        private final AtomicLong requested = new AtomicLong();
        private final Subscriber<? super T> downstream;
        private AtomicReference<PublishSubscriber<T>> parent = new AtomicReference();
        long emitted;

        InnerSubscriber(Subscriber<? super T> child) {
            this.downstream = child;
        }

        public void request(long n) {
            if (n > 0L) {
                PublishSubscriber<T> p;
                long r = this.requested.get();
                if (r != Long.MIN_VALUE && r != Long.MAX_VALUE) {
                    Subscriptions.add(this.requested, n);
                }
                if ((p = this.parent.get()) != null) {
                    p.drain();
                }
            }
        }

        public void cancel() {
            PublishSubscriber<T> p;
            long requests = this.requested.get();
            if (requests != Long.MIN_VALUE && (requests = this.requested.getAndSet(Long.MIN_VALUE)) != Long.MIN_VALUE && (p = this.parent.get()) != null) {
                p.remove(this);
                p.drain();
            }
        }
    }

    static final class PublishSubscriber<T>
    implements Cancellable,
    MultiSubscriber<T> {
        static final InnerSubscriber[] EMPTY = new InnerSubscriber[0];
        static final InnerSubscriber[] TERMINATED = new InnerSubscriber[0];
        final AtomicReference<PublishSubscriber<T>> current;
        final int bufferSize;
        final AtomicReference<InnerSubscriber<T>[]> subscribers;
        final AtomicBoolean shouldConnect;
        final AtomicReference<Subscription> upstream = new AtomicReference();
        private AtomicReference<Throwable> failureOrCompletion = new AtomicReference();
        private static final Throwable COMPLETED = new Exception();
        private final SpscArrayQueue<T> queue;
        private final AtomicBoolean cancelled = new AtomicBoolean();
        private final AtomicInteger wip = new AtomicInteger();

        PublishSubscriber(AtomicReference<PublishSubscriber<T>> current, int bufferSize) {
            this.subscribers = new AtomicReference<InnerSubscriber[]>(EMPTY);
            this.current = current;
            this.shouldConnect = new AtomicBoolean();
            this.bufferSize = bufferSize;
            this.queue = new SpscArrayQueue(bufferSize);
        }

        @Override
        public void cancel() {
            InnerSubscriber[] ps;
            this.cancelled.set(true);
            if (this.subscribers.get() != TERMINATED && (ps = this.subscribers.getAndSet(TERMINATED)) != TERMINATED) {
                this.current.compareAndSet(this, null);
                Subscriptions.cancel(this.upstream);
            }
        }

        public void onSubscribe(Subscription s) {
            if (this.upstream.compareAndSet(null, s)) {
                s.request((long)this.bufferSize);
            }
        }

        @Override
        public void onItem(T t) {
            if (!this.queue.offer(t)) {
                this.onFailure(new BackPressureFailure("Queue is full"));
                return;
            }
            this.drain();
        }

        @Override
        public void onFailure(Throwable e) {
            if (this.failureOrCompletion.compareAndSet(null, e)) {
                this.drain();
            }
        }

        @Override
        public void onCompletion() {
            if (this.failureOrCompletion.compareAndSet(null, COMPLETED)) {
                this.drain();
            }
        }

        boolean add(InnerSubscriber<T> producer) {
            InnerSubscriber[] u;
            InnerSubscriber<T>[] c;
            do {
                if ((c = this.subscribers.get()) == TERMINATED) {
                    return false;
                }
                int len = c.length;
                u = new InnerSubscriber[len + 1];
                System.arraycopy(c, 0, u, 0, len);
                u[len] = producer;
            } while (!this.subscribers.compareAndSet(c, u));
            return true;
        }

        void remove(InnerSubscriber<T> producer) {
            InnerSubscriber<T>[] c;
            int len;
            while ((len = (c = this.subscribers.get()).length) != 0) {
                InnerSubscriber[] u;
                int j = -1;
                for (int i = 0; i < len; ++i) {
                    if (!c[i].equals(producer)) continue;
                    j = i;
                    break;
                }
                if (j < 0) {
                    return;
                }
                if (len == 1) {
                    u = EMPTY;
                } else {
                    u = new InnerSubscriber[len - 1];
                    System.arraycopy(c, 0, u, 0, j);
                    System.arraycopy(c, j + 1, u, j, len - j - 1);
                }
                if (!this.subscribers.compareAndSet(c, u)) continue;
                break;
            }
        }

        boolean isEmptyOrCompleted(Throwable term, boolean empty) {
            if (term != null) {
                if (term == COMPLETED) {
                    if (empty) {
                        this.current.compareAndSet(this, null);
                        for (InnerSubscriber actual : this.subscribers.getAndSet(TERMINATED)) {
                            actual.downstream.onComplete();
                        }
                        return true;
                    }
                } else {
                    this.current.compareAndSet(this, null);
                    for (InnerSubscriber actual : this.subscribers.getAndSet(TERMINATED)) {
                        actual.downstream.onError(term);
                    }
                    return true;
                }
            }
            return false;
        }

        void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            AtomicReference<InnerSubscriber<T>[]> subscribers = this.subscribers;
            InnerSubscriber<T>[] ps = subscribers.get();
            block4: while (true) {
                SpscArrayQueue<T> q;
                boolean isEmpty;
                Throwable term;
                if (this.isEmptyOrCompleted(term = this.failureOrCompletion.get(), isEmpty = (q = this.queue).isEmpty())) {
                    return;
                }
                if (!isEmpty) {
                    int len = ps.length;
                    long maxRequested = Long.MAX_VALUE;
                    int cancelled = 0;
                    for (InnerSubscriber<T> ip : ps) {
                        long r = ((InnerSubscriber)ip).requested.get();
                        if (r != Long.MIN_VALUE) {
                            maxRequested = Math.min(maxRequested, r - ip.emitted);
                            continue;
                        }
                        ++cancelled;
                    }
                    if (len == cancelled) {
                        Object v;
                        term = this.failureOrCompletion.get();
                        try {
                            v = q.poll();
                        }
                        catch (Throwable ex) {
                            this.upstream.get().cancel();
                            term = ex;
                            this.failureOrCompletion.set(term);
                            v = null;
                        }
                        if (this.isEmptyOrCompleted(term, v == null)) {
                            return;
                        }
                        this.upstream.get().request(1L);
                        continue;
                    }
                    int d = 0;
                    while ((long)d < maxRequested) {
                        Object v;
                        term = this.failureOrCompletion.get();
                        try {
                            v = q.poll();
                        }
                        catch (Throwable ex) {
                            this.upstream.get().cancel();
                            term = ex;
                            this.failureOrCompletion.set(term);
                            v = null;
                        }
                        boolean bl = isEmpty = v == null;
                        if (this.isEmptyOrCompleted(term, isEmpty)) {
                            return;
                        }
                        if (isEmpty) break;
                        Object value = v;
                        boolean subscribersChanged = false;
                        for (InnerSubscriber<T> ip : ps) {
                            long ipr = ((InnerSubscriber)ip).requested.get();
                            if (ipr != Long.MIN_VALUE) {
                                if (ipr != Long.MAX_VALUE) {
                                    ++ip.emitted;
                                }
                                ((InnerSubscriber)ip).downstream.onNext(value);
                                continue;
                            }
                            subscribersChanged = true;
                        }
                        ++d;
                        InnerSubscriber<T>[] freshArray = subscribers.get();
                        if (!subscribersChanged && freshArray == ps) continue;
                        ps = freshArray;
                        if (d == 0) continue block4;
                        this.upstream.get().request((long)d);
                        continue block4;
                    }
                    if (d != 0) {
                        this.upstream.get().request((long)d);
                    }
                    if (maxRequested != 0L && !isEmpty) continue;
                }
                if ((missed = this.wip.addAndGet(-missed)) == 0) break;
                ps = subscribers.get();
            }
        }
    }
}

