/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.function.Predicate;

public final class MultiSkipUntilOp<T>
extends AbstractMultiOperator<T, T> {
    private final Predicate<? super T> predicate;

    public MultiSkipUntilOp(Multi<? extends T> upstream, Predicate<? super T> predicate) {
        super(upstream);
        this.predicate = ParameterValidation.nonNull(predicate, "predicate");
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> actual) {
        ParameterValidation.nonNullNpe(actual, "subscriber");
        this.upstream.subscribe(new SkipUntilProcessor<T>(actual, this.predicate));
    }

    static final class SkipUntilProcessor<T>
    extends MultiOperatorProcessor<T, T> {
        private final Predicate<? super T> predicate;
        private boolean gateOpen = false;

        SkipUntilProcessor(MultiSubscriber<? super T> downstream, Predicate<? super T> predicate) {
            super(downstream);
            this.predicate = predicate;
        }

        @Override
        public void onItem(T t) {
            boolean toBeSkipped;
            if (this.isDone()) {
                return;
            }
            if (this.gateOpen) {
                this.downstream.onItem(t);
                return;
            }
            try {
                toBeSkipped = this.predicate.test(t);
            }
            catch (Throwable e) {
                this.failAndCancel(e);
                return;
            }
            if (!toBeSkipped) {
                this.gateOpen = true;
                this.downstream.onItem(t);
                return;
            }
            this.request(1L);
        }
    }
}

