/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import io.smallrye.mutiny.subscription.SwitchableSubscriptionSubscriber;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Subscription;

public class MultiRepeatOp<T>
extends AbstractMultiOperator<T, T>
implements Multi<T> {
    private final long times;

    public MultiRepeatOp(Multi<T> upstream, long times) {
        super(upstream);
        this.times = times;
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> downstream) {
        ParameterValidation.nonNullNpe(downstream, "downstream");
        RepeatProcessor<? super T> processor = new RepeatProcessor<T>(this.upstream, downstream, this.times != Long.MAX_VALUE ? this.times - 1L : Long.MAX_VALUE);
        downstream.onSubscribe(processor);
        this.upstream.subscribe(processor);
    }

    static final class RepeatProcessor<T>
    extends SwitchableSubscriptionSubscriber<T> {
        private final Multi<? extends T> upstream;
        private long remaining;
        private long emitted;
        private final AtomicInteger wip = new AtomicInteger();

        public RepeatProcessor(Multi<? extends T> upstream, MultiSubscriber<? super T> downstream, long times) {
            super(downstream);
            this.upstream = upstream;
            this.remaining = times;
        }

        @Override
        public void onSubscribe(Subscription s) {
            this.setOrSwitchUpstream(s);
        }

        @Override
        public void onItem(T t) {
            ++this.emitted;
            this.downstream.onNext(t);
        }

        @Override
        public void onFailure(Throwable t) {
            this.downstream.onError(t);
        }

        @Override
        public void onCompletion() {
            long r = this.remaining;
            if (r != Long.MAX_VALUE) {
                this.remaining = r - 1L;
            }
            if (r != 0L) {
                this.subscribeNext();
            } else {
                this.downstream.onComplete();
            }
        }

        void subscribeNext() {
            if (this.wip.getAndIncrement() == 0) {
                int missed = 1;
                while (!this.isCancelled()) {
                    long p = this.emitted;
                    if (p != 0L) {
                        this.emitted = 0L;
                        this.emitted(p);
                    }
                    this.upstream.subscribe(this);
                    if ((missed = this.wip.addAndGet(-missed)) != 0) continue;
                    break;
                }
            }
        }
    }
}

