/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.converters.UniConverter;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.UniCreateFromCompletionStage;
import io.smallrye.mutiny.operators.UniCreateFromDeferredSupplier;
import io.smallrye.mutiny.operators.UniCreateFromPublisher;
import io.smallrye.mutiny.operators.UniCreateWithEmitter;
import io.smallrye.mutiny.operators.UniNever;
import io.smallrye.mutiny.subscription.UniEmitter;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;

public class UniCreate {
    public static final UniCreate INSTANCE = new UniCreate();

    private UniCreate() {
    }

    public <I, T> Uni<T> converter(UniConverter<I, T> converter, I instance) {
        return converter.from(instance);
    }

    public <T> Uni<T> completionStage(CompletionStage<? extends T> stage) {
        CompletionStage actual = ParameterValidation.nonNull(stage, "stage");
        return this.completionStage(() -> actual);
    }

    public <T> Uni<T> completionStage(Supplier<? extends CompletionStage<? extends T>> supplier) {
        return Infrastructure.onUniCreation(new UniCreateFromCompletionStage(ParameterValidation.nonNull(supplier, "supplier")));
    }

    public <T> Uni<T> publisher(Publisher<? extends T> publisher) {
        Publisher<? extends T> actual = ParameterValidation.nonNull(publisher, "publisher");
        return Infrastructure.onUniCreation(new UniCreateFromPublisher<T>(actual));
    }

    public <T> Uni<T> item(Supplier<? extends T> supplier) {
        Supplier actual = ParameterValidation.nonNull(supplier, "supplier");
        return this.emitter(emitter -> {
            Object item;
            try {
                item = actual.get();
            }
            catch (RuntimeException e) {
                emitter.fail(e);
                return;
            }
            emitter.complete(item);
        });
    }

    public <T> Uni<T> item(T item) {
        return this.item((T)((Supplier<Object>)() -> item));
    }

    public <T> Uni<T> optional(Optional<T> optional) {
        Optional actual = ParameterValidation.nonNull(optional, "optional");
        return this.optional(() -> actual);
    }

    public <T> Uni<T> optional(Supplier<Optional<T>> supplier) {
        Supplier actual = ParameterValidation.nonNull(supplier, "supplier");
        return this.item((T)((Supplier<Object>)() -> ((Optional)actual.get()).orElse(null)));
    }

    public <T> Uni<T> emitter(Consumer<UniEmitter<? super T>> consumer) {
        Consumer<UniEmitter<? super T>> actual = ParameterValidation.nonNull(consumer, "consumer");
        return Infrastructure.onUniCreation(new UniCreateWithEmitter<T>(actual));
    }

    public <T> Uni<T> deferred(Supplier<? extends Uni<? extends T>> supplier) {
        Supplier<? extends Uni<? extends T>> actual = ParameterValidation.nonNull(supplier, "supplier");
        return Infrastructure.onUniCreation(new UniCreateFromDeferredSupplier(actual));
    }

    public <T> Uni<T> failure(Throwable failure) {
        Throwable exception = ParameterValidation.nonNull(failure, "failure");
        return this.failure(() -> exception);
    }

    public <T> Uni<T> failure(Supplier<Throwable> supplier) {
        Supplier<Throwable> actual = ParameterValidation.nonNull(supplier, "supplier");
        return this.emitter(emitter -> {
            Throwable throwable;
            try {
                throwable = (Throwable)actual.get();
            }
            catch (Exception e) {
                emitter.fail(e);
                return;
            }
            if (throwable == null) {
                emitter.fail(new NullPointerException("The supplier returned `null`"));
            } else {
                emitter.fail(throwable);
            }
        });
    }

    public <T> Uni<T> nothing() {
        return UniNever.INSTANCE;
    }

    public <T> Uni<T> multi(Multi<T> multi) {
        ParameterValidation.nonNull(multi, "multi");
        return multi.toUni();
    }
}

