/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.subscription;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.helpers.Subscriptions;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class SafeSubscriber<T>
implements Subscriber<T>,
Subscription {
    private final Subscriber<? super T> downstream;
    private final AtomicReference<Subscription> upstream = new AtomicReference();
    private boolean done;

    public SafeSubscriber(Subscriber<? super T> downstream) {
        this.downstream = downstream;
    }

    public void onSubscribe(Subscription s) {
        if (this.upstream.compareAndSet(null, s)) {
            try {
                this.downstream.onSubscribe((Subscription)this);
            }
            catch (Throwable e) {
                this.done = true;
                try {
                    s.cancel();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public void onNext(T t) {
        if (this.done) {
            return;
        }
        if (this.upstream.get() == null) {
            this.onNextNoSubscription();
            return;
        }
        if (t == null) {
            NullPointerException ex = new NullPointerException("onNext called with null.");
            this.cancelAndDispatch(ex);
            return;
        }
        try {
            this.downstream.onNext(t);
        }
        catch (Throwable e) {
            this.cancelAndDispatch(e);
        }
    }

    private void cancelAndDispatch(Throwable ex) {
        try {
            this.upstream.get().cancel();
        }
        catch (Throwable e1) {
            this.onError(new CompositeException(ex, e1));
            return;
        }
        this.onError(ex);
    }

    private void onNextNoSubscription() {
        this.done = true;
        this.manageViolationProtocol();
    }

    public void onError(Throwable t) {
        if (this.done) {
            return;
        }
        this.done = true;
        if (this.upstream.get() == null) {
            NullPointerException npe = new NullPointerException("Subscription not set!");
            try {
                this.downstream.onSubscribe(Subscriptions.empty());
            }
            catch (Throwable e) {
                return;
            }
            try {
                this.downstream.onError((Throwable)new CompositeException(t, npe));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
        if (t == null) {
            t = new NullPointerException("onError called with null.");
        }
        try {
            this.downstream.onError(t);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        if (this.upstream.get() == null) {
            this.onCompleteNoSubscription();
            return;
        }
        try {
            this.downstream.onComplete();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void onCompleteNoSubscription() {
        this.manageViolationProtocol();
    }

    private void manageViolationProtocol() {
        NullPointerException ex = new NullPointerException("Subscription not set!");
        try {
            this.downstream.onSubscribe(Subscriptions.empty());
        }
        catch (Throwable e) {
            return;
        }
        try {
            this.downstream.onError((Throwable)ex);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void request(long n) {
        try {
            this.upstream.get().request(n);
        }
        catch (Throwable e) {
            try {
                this.upstream.get().cancel();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void cancel() {
        try {
            this.upstream.get().cancel();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

