/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi.overflow;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class MultiOnOverflowKeepLastOp<T>
extends AbstractMultiOperator<T, T> {
    public MultiOnOverflowKeepLastOp(Multi<T> upstream) {
        super(upstream);
    }

    @Override
    public void subscribe(Subscriber<? super T> downstream) {
        this.upstream.subscribe(new MultiOnOverflowLatestProcessor<T>(downstream));
    }

    static final class MultiOnOverflowLatestProcessor<T>
    extends MultiOperatorProcessor<T, T> {
        private final AtomicInteger wip = new AtomicInteger();
        private Throwable failure;
        private final AtomicLong requested = new AtomicLong();
        private volatile boolean done;
        private volatile boolean cancelled;
        private final AtomicReference<T> last = new AtomicReference();

        MultiOnOverflowLatestProcessor(Subscriber<? super T> downstream) {
            super(downstream);
        }

        @Override
        public void onSubscribe(Subscription subscription) {
            if (this.upstream.compareAndSet(null, subscription)) {
                this.downstream.onSubscribe((Subscription)this);
                subscription.request(Long.MAX_VALUE);
            } else {
                subscription.cancel();
            }
        }

        public void onNext(T t) {
            this.last.lazySet(t);
            this.drain();
        }

        @Override
        public void onError(Throwable f) {
            this.failure = f;
            this.done = true;
            this.drain();
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public void request(long n) {
            if (n > 0L) {
                Subscriptions.add(this.requested, n);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                super.cancel();
                if (this.wip.getAndIncrement() == 0) {
                    this.last.lazySet(null);
                }
            }
        }

        void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            AtomicLong req = this.requested;
            do {
                long emitted;
                for (emitted = 0L; emitted != req.get(); ++emitted) {
                    boolean isEmpty;
                    boolean isDone = this.done;
                    Object v = this.last.getAndSet(null);
                    boolean bl = isEmpty = v == null;
                    if (this.checkTerminated(isDone, isEmpty)) {
                        return;
                    }
                    if (isEmpty) break;
                    this.downstream.onNext(v);
                }
                if (emitted == req.get() && this.checkTerminated(this.done, this.last.get() == null)) {
                    return;
                }
                if (emitted == 0L) continue;
                Subscriptions.subtract(req, emitted);
            } while ((missed = this.wip.addAndGet(-missed)) != 0);
        }

        boolean checkTerminated(boolean wasDone, boolean wasEmpty) {
            if (this.cancelled) {
                this.last.lazySet(null);
                return true;
            }
            if (wasDone) {
                if (this.failure != null) {
                    this.last.lazySet(null);
                    super.onError(this.failure);
                    return true;
                }
                if (wasEmpty) {
                    super.onComplete();
                    return true;
                }
            }
            return false;
        }
    }
}

