/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi.multicast;

import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.operators.multi.multicast.ConnectableMultiConnection;
import io.smallrye.mutiny.operators.multi.multicast.MultiReferenceCount;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Subscriber;

public class MultiReferenceCountSubscriber<T>
extends MultiOperatorProcessor<T, T> {
    private final AtomicBoolean done = new AtomicBoolean();
    private final MultiReferenceCount<T> parent;
    private final ConnectableMultiConnection connection;

    MultiReferenceCountSubscriber(Subscriber<? super T> downstream, MultiReferenceCount<T> parent, ConnectableMultiConnection connection) {
        super(downstream);
        this.parent = parent;
        this.connection = connection;
    }

    public void onNext(T t) {
        this.downstream.onNext(t);
    }

    @Override
    public void onError(Throwable failure) {
        if (this.done.compareAndSet(false, true)) {
            this.parent.terminated(this.connection);
            super.onError(failure);
        }
    }

    @Override
    public void onComplete() {
        if (this.done.compareAndSet(false, true)) {
            this.parent.terminated(this.connection);
            super.onComplete();
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        if (this.done.compareAndSet(false, true)) {
            this.parent.cancel(this.connection);
        }
    }
}

