/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi.builders;

import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.AbstractMulti;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class IterableBasedMulti<T>
extends AbstractMulti<T> {
    private final Iterable<? extends T> source;

    public IterableBasedMulti(Iterable<? extends T> source) {
        this.source = source;
    }

    @Override
    protected Publisher<T> publisher() {
        return this;
    }

    @Override
    public void subscribe(Subscriber<? super T> downstream) {
        Iterator<? extends T> iterator;
        ParameterValidation.nonNullNpe(downstream, "subscriber");
        try {
            iterator = this.source.iterator();
        }
        catch (Throwable e) {
            Subscriptions.fail(downstream, e);
            return;
        }
        IterableBasedMulti.subscribe(downstream, iterator);
    }

    public static <T> void subscribe(Subscriber<? super T> downstream, Iterator<? extends T> it) {
        boolean hasNext;
        try {
            hasNext = it.hasNext();
        }
        catch (Throwable e) {
            Subscriptions.fail(downstream, e);
            return;
        }
        if (!hasNext) {
            Subscriptions.complete(downstream);
            return;
        }
        downstream.onSubscribe(new IteratorSubscription<T>(downstream, it));
    }

    static final class IteratorSubscription<T>
    extends BaseRangeSubscription<T> {
        IteratorSubscription(Subscriber<? super T> actual, Iterator<? extends T> it) {
            super(actual, it);
        }

        @Override
        void fastPath() {
            boolean b;
            do {
                Object t;
                if (this.cancelled) {
                    return;
                }
                try {
                    t = this.iterator.next();
                }
                catch (Throwable ex) {
                    this.downstream.onError(ex);
                    return;
                }
                if (this.cancelled) {
                    return;
                }
                if (t == null) {
                    this.downstream.onError((Throwable)new NullPointerException("Iterator.next() returned a null value"));
                    return;
                }
                this.downstream.onNext(t);
                if (this.cancelled) {
                    return;
                }
                try {
                    b = this.iterator.hasNext();
                }
                catch (Throwable ex) {
                    this.downstream.onError(ex);
                    return;
                }
            } while (b);
            if (!this.cancelled) {
                this.downstream.onComplete();
            }
        }

        @Override
        void slowPath(long r) {
            long e = 0L;
            while (true) {
                if (e != r) {
                    boolean b;
                    Object t;
                    if (this.cancelled) {
                        return;
                    }
                    try {
                        t = this.iterator.next();
                    }
                    catch (Throwable ex) {
                        this.downstream.onError(ex);
                        return;
                    }
                    if (this.cancelled) {
                        return;
                    }
                    if (t == null) {
                        this.downstream.onError((Throwable)new NullPointerException("Iterator.next() returned a null value"));
                        return;
                    }
                    this.downstream.onNext(t);
                    if (this.cancelled) {
                        return;
                    }
                    try {
                        b = this.iterator.hasNext();
                    }
                    catch (Throwable ex) {
                        this.downstream.onError(ex);
                        return;
                    }
                    if (!b) {
                        if (!this.cancelled) {
                            this.downstream.onComplete();
                        }
                        return;
                    }
                    ++e;
                    continue;
                }
                r = this.requested.get();
                if (e != r) continue;
                r = this.requested.addAndGet(-e);
                if (r == 0L) {
                    return;
                }
                e = 0L;
            }
        }
    }

    static abstract class BaseRangeSubscription<T>
    implements Subscription {
        protected final Iterator<? extends T> iterator;
        protected final Subscriber<? super T> downstream;
        protected volatile boolean cancelled;
        protected boolean once;
        protected final AtomicLong requested = new AtomicLong();

        BaseRangeSubscription(Subscriber<? super T> downstream, Iterator<? extends T> iterator) {
            this.downstream = downstream;
            this.iterator = iterator;
        }

        public final void request(long n) {
            if (n > 0L) {
                if (Subscriptions.add(this.requested, n) == 0L) {
                    if (n == Long.MAX_VALUE) {
                        this.fastPath();
                    } else {
                        this.slowPath(n);
                    }
                }
            } else {
                this.downstream.onError((Throwable)Subscriptions.getInvalidRequestException());
            }
        }

        public final void cancel() {
            this.cancelled = true;
        }

        abstract void fastPath();

        abstract void slowPath(long var1);
    }
}

