/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.SerializedSubscriber;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class MultiTakeUntilOtherOp<T, U>
extends AbstractMultiOperator<T, T> {
    private final Publisher<U> other;

    public MultiTakeUntilOtherOp(Multi<? extends T> upstream, Publisher<U> other) {
        super(upstream);
        this.other = ParameterValidation.nonNull(other, "other");
    }

    @Override
    public void subscribe(Subscriber<? super T> actual) {
        TakeUntilMainProcessor<? super T> mainSubscriber = new TakeUntilMainProcessor<T>(actual);
        TakeUntilOtherSubscriber otherSubscriber = new TakeUntilOtherSubscriber(mainSubscriber);
        this.other.subscribe(otherSubscriber);
        this.upstream.subscribe(mainSubscriber);
    }

    static final class TakeUntilMainProcessor<T>
    extends MultiOperatorProcessor<T, T> {
        private final AtomicReference<Subscription> other = new AtomicReference();

        TakeUntilMainProcessor(Subscriber<? super T> downstream) {
            super(new SerializedSubscriber<T>(downstream));
        }

        void setOtherSubscription(Subscription s) {
            if (this.other.compareAndSet(null, s)) {
                s.request(1L);
            } else {
                s.cancel();
            }
        }

        @Override
        public void cancel() {
            super.cancel();
            Subscriptions.cancel(this.other);
        }

        public void onNext(T t) {
            if (!this.isDone()) {
                this.downstream.onNext(t);
            }
        }

        @Override
        public void onError(Throwable failure) {
            super.onError(failure);
            Subscriptions.cancel(this.other);
        }

        @Override
        public void onComplete() {
            super.onComplete();
            Subscriptions.cancel(this.other);
        }
    }

    static final class TakeUntilOtherSubscriber<U>
    implements Subscriber<U> {
        final TakeUntilMainProcessor<?> main;
        boolean once;

        TakeUntilOtherSubscriber(TakeUntilMainProcessor<?> main) {
            this.main = main;
        }

        public void onSubscribe(Subscription s) {
            this.main.setOtherSubscription(s);
        }

        public void onNext(U t) {
            this.onComplete();
        }

        public void onError(Throwable t) {
            if (this.once) {
                return;
            }
            this.once = true;
            this.main.onError(t);
        }

        public void onComplete() {
            if (this.once) {
                return;
            }
            this.once = true;
            this.main.onComplete();
        }
    }
}

