/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import java.util.ArrayDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class MultiTakeLastOp<T>
extends AbstractMultiOperator<T, T> {
    private final int numberOfItems;

    public MultiTakeLastOp(Multi<? extends T> upstream, int numberOfItems) {
        super(upstream);
        this.numberOfItems = ParameterValidation.positiveOrZero(numberOfItems, "numberOfItems");
    }

    @Override
    public void subscribe(Subscriber<? super T> actual) {
        if (this.numberOfItems == 0) {
            this.upstream.subscribe(new TakeLastZeroProcessor<T>(actual));
        } else {
            this.upstream.subscribe(new TakeLastManyProcessor<T>(actual, this.numberOfItems));
        }
    }

    static final class TakeLastManyProcessor<T>
    extends MultiOperatorProcessor<T, T> {
        private final int numberOfItems;
        private final ArrayDeque<T> queue;
        private final AtomicLong requested = new AtomicLong();
        private final AtomicInteger wip = new AtomicInteger();
        volatile boolean upstreamCompleted;

        TakeLastManyProcessor(Subscriber<? super T> downstream, int numberOfItems) {
            super(downstream);
            this.numberOfItems = numberOfItems;
            this.queue = new ArrayDeque(numberOfItems);
        }

        @Override
        public void request(long n) {
            if (n > 0L) {
                Subscriptions.add(this.requested, n);
                this.drain();
            }
        }

        @Override
        public void onSubscribe(Subscription subscription) {
            if (this.upstream.compareAndSet(null, subscription)) {
                this.downstream.onSubscribe((Subscription)this);
                subscription.request(Long.MAX_VALUE);
            } else {
                subscription.cancel();
            }
        }

        public void onNext(T t) {
            if (this.queue.size() == this.numberOfItems) {
                this.queue.poll();
            }
            this.queue.offer(t);
        }

        @Override
        public void onComplete() {
            this.upstreamCompleted = true;
            this.drain();
        }

        private void drain() {
            if (this.wip.getAndIncrement() == 0) {
                long req = this.requested.get();
                do {
                    long count;
                    if (this.upstream.get() == Subscriptions.CANCELLED) {
                        return;
                    }
                    if (!this.upstreamCompleted) continue;
                    for (count = 0L; count != req; ++count) {
                        if (this.upstream.get() == Subscriptions.CANCELLED) {
                            return;
                        }
                        T item = this.queue.poll();
                        if (item == null) {
                            this.downstream.onComplete();
                            return;
                        }
                        this.downstream.onNext(item);
                    }
                    if (count == 0L || req == Long.MAX_VALUE) continue;
                    req = this.requested.addAndGet(-count);
                } while (this.wip.decrementAndGet() != 0);
            }
        }
    }

    static final class TakeLastZeroProcessor<T>
    extends MultiOperatorProcessor<T, T> {
        TakeLastZeroProcessor(Subscriber<? super T> downstream) {
            super(downstream);
        }

        @Override
        public void onSubscribe(Subscription subscription) {
            if (this.upstream.compareAndSet(null, subscription)) {
                this.downstream.onSubscribe((Subscription)this);
                subscription.request(Long.MAX_VALUE);
            } else {
                subscription.cancel();
            }
        }

        public void onNext(T t) {
        }
    }
}

