/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import java.util.function.Predicate;
import org.reactivestreams.Subscriber;

public final class MultiSkipUntilOp<T>
extends AbstractMultiOperator<T, T> {
    private final Predicate<? super T> predicate;

    public MultiSkipUntilOp(Multi<? extends T> upstream, Predicate<? super T> predicate) {
        super(upstream);
        this.predicate = ParameterValidation.nonNull(predicate, "predicate");
    }

    @Override
    public void subscribe(Subscriber<? super T> actual) {
        ParameterValidation.nonNullNpe(actual, "subscriber");
        this.upstream.subscribe(new SkipUntilProcessor<T>(actual, this.predicate));
    }

    static final class SkipUntilProcessor<T>
    extends MultiOperatorProcessor<T, T> {
        private final Predicate<? super T> predicate;
        private boolean gateOpen = false;

        SkipUntilProcessor(Subscriber<? super T> downstream, Predicate<? super T> predicate) {
            super(downstream);
            this.predicate = predicate;
        }

        public void onNext(T t) {
            boolean toBeSkipped;
            if (this.isDone()) {
                return;
            }
            if (this.gateOpen) {
                this.downstream.onNext(t);
                return;
            }
            try {
                toBeSkipped = this.predicate.test(t);
            }
            catch (Throwable e) {
                this.failAndCancel(e);
                return;
            }
            if (!toBeSkipped) {
                this.gateOpen = true;
                this.downstream.onNext(t);
                return;
            }
            this.request(1L);
        }
    }
}

