/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class MultiSkipOp<T>
extends AbstractMultiOperator<T, T> {
    private final long numberOfItems;

    public MultiSkipOp(Multi<? extends T> upstream, long numberOfItems) {
        super(upstream);
        this.numberOfItems = ParameterValidation.positiveOrZero(numberOfItems, "numberOfItems");
    }

    @Override
    public void subscribe(Subscriber<? super T> actual) {
        if (this.numberOfItems == 0L) {
            this.upstream.subscribe(actual);
        } else {
            this.upstream.subscribe(new SkipProcessor<T>(actual, this.numberOfItems));
        }
    }

    static final class SkipProcessor<T>
    extends MultiOperatorProcessor<T, T> {
        private final AtomicLong remaining;

        SkipProcessor(Subscriber<? super T> downstream, long items) {
            super(downstream);
            this.remaining = new AtomicLong(items);
        }

        @Override
        public void onSubscribe(Subscription subscription) {
            if (this.upstream.compareAndSet(null, subscription)) {
                this.downstream.onSubscribe((Subscription)this);
                subscription.request(this.remaining.get());
            } else {
                subscription.cancel();
            }
        }

        public void onNext(T t) {
            long r = this.remaining.getAndDecrement();
            if (r <= 0L) {
                this.downstream.onNext(t);
            }
        }
    }
}

