/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class MultiSignalConsumerOp<T>
extends AbstractMultiOperator<T, T> {
    private final Consumer<? super Subscription> onSubscribe;
    private final Consumer<? super T> onItem;
    private final Consumer<? super Throwable> onFailure;
    private final Runnable onCompletion;
    private final BiConsumer<Throwable, Boolean> onTermination;
    private final Runnable onCancellation;
    private final LongConsumer onRequest;

    public MultiSignalConsumerOp(Multi<? extends T> upstream, Consumer<? super Subscription> onSubscribe, Consumer<? super T> onItem, Consumer<? super Throwable> onFailure, Runnable onCompletion, BiConsumer<Throwable, Boolean> onTermination, LongConsumer onRequest, Runnable onCancellation) {
        super(upstream);
        this.onSubscribe = onSubscribe;
        this.onItem = onItem;
        this.onFailure = onFailure;
        this.onCompletion = onCompletion;
        this.onRequest = onRequest;
        this.onTermination = onTermination;
        this.onCancellation = onCancellation;
    }

    @Override
    public void subscribe(Subscriber<? super T> actual) {
        if (actual == null) {
            throw new NullPointerException("Subscriber must not be `null`");
        }
        this.upstream.subscribe(new SignalSubscriber(actual));
    }

    private final class SignalSubscriber
    implements Subscriber<T>,
    Subscription {
        private final Subscriber<? super T> downstream;
        private final AtomicReference<Subscription> subscription = new AtomicReference();

        SignalSubscriber(Subscriber<? super T> downstream) {
            this.downstream = downstream;
        }

        void failAndCancel(Throwable throwable) {
            Subscription current = this.subscription.get();
            if (current != null) {
                current.cancel();
            }
            this.onError(throwable);
        }

        public void request(long n) {
            if (MultiSignalConsumerOp.this.onRequest != null) {
                try {
                    MultiSignalConsumerOp.this.onRequest.accept(n);
                }
                catch (Throwable e) {
                    this.failAndCancel(e);
                    return;
                }
            }
            this.subscription.get().request(n);
        }

        public void cancel() {
            if (MultiSignalConsumerOp.this.onCancellation != null) {
                try {
                    MultiSignalConsumerOp.this.onCancellation.run();
                }
                catch (Throwable e) {
                    this.failAndCancel(e);
                    return;
                }
            }
            if (MultiSignalConsumerOp.this.onTermination != null) {
                try {
                    MultiSignalConsumerOp.this.onTermination.accept(null, true);
                }
                catch (Throwable e) {
                    return;
                }
            }
            this.subscription.getAndSet(Subscriptions.CANCELLED).cancel();
        }

        public void onSubscribe(Subscription s) {
            if (this.subscription.compareAndSet(null, s)) {
                if (MultiSignalConsumerOp.this.onSubscribe != null) {
                    try {
                        MultiSignalConsumerOp.this.onSubscribe.accept(s);
                    }
                    catch (Throwable e) {
                        Subscriptions.fail(this.downstream, e);
                        this.subscription.getAndSet(Subscriptions.CANCELLED).cancel();
                        return;
                    }
                }
                this.downstream.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (this.subscription.get() != Subscriptions.CANCELLED) {
                if (MultiSignalConsumerOp.this.onItem != null) {
                    try {
                        MultiSignalConsumerOp.this.onItem.accept(t);
                    }
                    catch (Throwable e) {
                        this.failAndCancel(e);
                        return;
                    }
                }
                this.downstream.onNext(t);
            }
        }

        public void onError(Throwable failure) {
            Subscription up = this.subscription.getAndSet(Subscriptions.CANCELLED);
            if (up != Subscriptions.CANCELLED) {
                if (MultiSignalConsumerOp.this.onFailure != null) {
                    try {
                        MultiSignalConsumerOp.this.onFailure.accept(failure);
                    }
                    catch (Throwable e) {
                        failure = new CompositeException(failure, e);
                    }
                }
                this.downstream.onError(failure);
                if (MultiSignalConsumerOp.this.onTermination != null) {
                    try {
                        MultiSignalConsumerOp.this.onTermination.accept(failure, false);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }

        public void onComplete() {
            if (this.subscription.getAndSet(Subscriptions.CANCELLED) != Subscriptions.CANCELLED) {
                if (MultiSignalConsumerOp.this.onCompletion != null) {
                    try {
                        MultiSignalConsumerOp.this.onCompletion.run();
                    }
                    catch (Throwable e) {
                        this.downstream.onError(e);
                        return;
                    }
                }
                if (MultiSignalConsumerOp.this.onTermination != null) {
                    try {
                        MultiSignalConsumerOp.this.onTermination.accept(null, false);
                    }
                    catch (Throwable e) {
                        this.downstream.onError(e);
                        return;
                    }
                }
                this.downstream.onComplete();
            }
        }
    }
}

