/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import java.util.function.BiFunction;
import org.reactivestreams.Subscriber;

public final class MultiScanOp<T>
extends AbstractMultiOperator<T, T> {
    private final BiFunction<T, ? super T, T> accumulator;

    public MultiScanOp(Multi<? extends T> upstream, BiFunction<T, ? super T, T> accumulator) {
        super(upstream);
        this.accumulator = ParameterValidation.nonNull(accumulator, "accumulator");
    }

    @Override
    public void subscribe(Subscriber<? super T> downstream) {
        this.upstream.subscribe(new ScanProcessor<T>(downstream, this.accumulator));
    }

    static final class ScanProcessor<T>
    extends MultiOperatorProcessor<T, T> {
        private final BiFunction<T, ? super T, T> accumulator;
        private T current;

        ScanProcessor(Subscriber<? super T> downstream, BiFunction<T, ? super T, T> accumulator) {
            super(downstream);
            this.accumulator = accumulator;
        }

        public void onNext(T item) {
            if (this.isDone()) {
                return;
            }
            T result = item;
            if (this.current != null) {
                try {
                    result = this.accumulator.apply(this.current, item);
                }
                catch (Throwable e) {
                    this.onError(e);
                    return;
                }
                if (result == null) {
                    this.onError(new NullPointerException("The mapper returned `null`"));
                    return;
                }
            }
            this.current = result;
            this.downstream.onNext(item);
        }

        @Override
        public void onError(Throwable failure) {
            super.onError(failure);
            this.current = null;
        }

        @Override
        public void onComplete() {
            super.onComplete();
            this.current = null;
        }
    }
}

