/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

abstract class FlatMapManager<T> {
    private AtomicReference<T[]> inners = new AtomicReference<T[]>(this.empty());
    private int[] free = FREE_EMPTY;
    private long producerIndex;
    private long consumerIndex;
    private AtomicInteger size = new AtomicInteger();
    private static final int[] FREE_EMPTY = new int[0];

    FlatMapManager() {
    }

    abstract T[] empty();

    abstract T[] terminated();

    abstract T[] newArray(int var1);

    abstract void unsubscribeEntry(T var1, boolean var2);

    abstract void setIndex(T var1, int var2);

    final void unsubscribe() {
        this.unsubscribe(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void unsubscribe(boolean fromOnError) {
        T[] t = this.terminated();
        T[] TArray = this;
        synchronized (this) {
            T[] a = this.inners.get();
            if (a == t) {
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return;
            }
            this.size.lazySet(0);
            this.free = null;
            this.inners.set(t);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            for (T e : a) {
                if (e == null) continue;
                this.unsubscribeEntry(e, fromOnError);
            }
            return;
        }
    }

    final T[] get() {
        return this.inners.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean add(T entry) {
        T[] a = this.inners.get();
        if (a == this.terminated()) {
            return false;
        }
        FlatMapManager flatMapManager = this;
        synchronized (flatMapManager) {
            a = this.inners.get();
            if (a == this.terminated()) {
                return false;
            }
            int idx = this.pollFree();
            if (idx < 0) {
                int n = a.length;
                T[] b = n != 0 ? this.newArray(n << 1) : this.newArray(4);
                System.arraycopy(a, 0, b, 0, n);
                this.inners.set(b);
                a = b;
                int m = b.length;
                int[] u = new int[m];
                for (int i = n + 1; i < m; ++i) {
                    u[i] = i;
                }
                this.free = u;
                this.consumerIndex = (long)n + 1L;
                this.producerIndex = m;
                idx = n;
            }
            this.setIndex(entry, idx);
            a[idx] = entry;
            this.size.incrementAndGet();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void remove(int index) {
        FlatMapManager flatMapManager = this;
        synchronized (flatMapManager) {
            T[] a = this.inners.get();
            if (a != this.terminated()) {
                a[index] = null;
                this.offerFree(index);
                this.size.decrementAndGet();
            }
        }
    }

    private int pollFree() {
        int[] a = this.free;
        int m = a.length - 1;
        long ci = this.consumerIndex;
        if (this.producerIndex == ci) {
            return -1;
        }
        int offset = (int)ci & m;
        this.consumerIndex = ci + 1L;
        return a[offset];
    }

    private void offerFree(int index) {
        int[] a = this.free;
        int m = a.length - 1;
        long pi = this.producerIndex;
        int offset = (int)pi & m;
        a[offset] = index;
        this.producerIndex = pi + 1L;
    }

    final boolean isEmpty() {
        return this.size.get() == 0;
    }
}

