/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.infrastructure;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.ExecutorConfiguration;
import io.smallrye.mutiny.infrastructure.UniInterceptor;
import io.smallrye.mutiny.subscription.UniSubscriber;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class Infrastructure {
    private static final ScheduledExecutorService DEFAULT_SCHEDULER;
    private static final Executor DEFAULT_EXECUTOR;
    private static final List<UniInterceptor> UNI_INTERCEPTORS;

    public static ScheduledExecutorService getDefaultWorkerPool() {
        return DEFAULT_SCHEDULER;
    }

    public static Executor getDefaultExecutor() {
        return DEFAULT_EXECUTOR;
    }

    public static <T> Uni<T> onUniCreation(Uni<T> instance) {
        Uni<T> current = instance;
        for (UniInterceptor itcp : UNI_INTERCEPTORS) {
            current = itcp.onUniCreation(current);
        }
        return current;
    }

    public static <T> UniSubscriber<? super T> onUniSubscription(Uni<T> instance, UniSubscriber<? super T> subscriber) {
        UniSubscriber<? super T> current = subscriber;
        for (UniInterceptor itcp : UNI_INTERCEPTORS) {
            current = itcp.onSubscription(instance, current);
        }
        return current;
    }

    static void registerUniInterceptor(UniInterceptor e) {
        UNI_INTERCEPTORS.add(e);
        UNI_INTERCEPTORS.sort(Comparator.comparingInt(UniInterceptor::ordinal));
    }

    static void clearUniInterceptors() {
        UNI_INTERCEPTORS.clear();
    }

    static List<UniInterceptor> getUniInterceptors() {
        return UNI_INTERCEPTORS;
    }

    private Infrastructure() {
    }

    static {
        ServiceLoader<ExecutorConfiguration> executorLoader = ServiceLoader.load(ExecutorConfiguration.class);
        Iterator<ExecutorConfiguration> iterator = executorLoader.iterator();
        if (iterator.hasNext()) {
            ExecutorConfiguration next = iterator.next();
            DEFAULT_EXECUTOR = ParameterValidation.nonNull(next.getDefaultWorkerExecutor(), "executor");
            DEFAULT_SCHEDULER = ParameterValidation.nonNull(next.getDefaultScheduledExecutor(), "scheduler");
        } else {
            ScheduledExecutorService scheduler;
            DEFAULT_SCHEDULER = scheduler = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors());
            DEFAULT_EXECUTOR = scheduler;
        }
        ServiceLoader<UniInterceptor> interceptorLoader = ServiceLoader.load(UniInterceptor.class);
        ArrayList<UniInterceptor> interceptors = new ArrayList<UniInterceptor>();
        interceptorLoader.iterator().forEachRemaining(interceptors::add);
        interceptors.sort(Comparator.comparingInt(UniInterceptor::ordinal));
        UNI_INTERCEPTORS = interceptors;
    }
}

