/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.UniRetryAtMost;
import java.util.function.Predicate;

public class UniRetry<T> {
    private final Uni<T> upstream;
    private final Predicate<? super Throwable> predicate;

    public UniRetry(Uni<T> upstream, Predicate<? super Throwable> predicate) {
        this.upstream = upstream;
        this.predicate = predicate;
    }

    public Uni<T> indefinitely() {
        return this.atMost(Long.MAX_VALUE);
    }

    public Uni<T> atMost(long numberOfAttempts) {
        return Infrastructure.onUniCreation(new UniRetryAtMost<T>(this.upstream, this.predicate, numberOfAttempts));
    }

    public Uni<T> until(Predicate<? super Throwable> predicate) {
        throw new UnsupportedOperationException("not yet implemented");
    }
}

