/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.Overflows;
import java.util.function.Consumer;

public class MultiOverflow<T> {
    private final Multi<T> upstream;

    public MultiOverflow(Multi<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    public Multi<T> buffer() {
        return Overflows.buffer(this.upstream);
    }

    public Multi<T> buffer(int size) {
        return Overflows.buffer(this.upstream, ParameterValidation.positive(size, "size"));
    }

    public Multi<T> drop() {
        return Overflows.dropNewItems(this.upstream);
    }

    public Multi<T> drop(Consumer<T> callback) {
        return Overflows.dropNewItems(this.upstream, ParameterValidation.nonNull(callback, "callback"));
    }

    public Multi<T> dropPreviousItems() {
        return Overflows.keepLastItem(this.upstream);
    }
}

