/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.MultiFlatten;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.multi.MultiIgnoreOp;
import io.smallrye.mutiny.operators.multi.MultiMapOp;
import io.smallrye.mutiny.operators.multi.MultiScanOp;
import io.smallrye.mutiny.operators.multi.MultiScanWithSeedOp;
import io.smallrye.mutiny.operators.multi.MultiSignalConsumerOp;
import io.smallrye.mutiny.subscription.BackPressureStrategy;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;

public class MultiOnItem<T> {
    private final Multi<T> upstream;

    public MultiOnItem(Multi<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    public <R> Multi<R> apply(Function<? super T, ? extends R> mapper) {
        return new MultiMapOp<T, R>(this.upstream, ParameterValidation.nonNull(mapper, "mapper"));
    }

    public Multi<T> invoke(Consumer<T> callback) {
        return new MultiSignalConsumerOp<T>(this.upstream, null, ParameterValidation.nonNull(callback, "callback"), null, null, null, null, null);
    }

    public <O> MultiFlatten<T, O> produceMulti(Function<? super T, ? extends Publisher<? extends O>> mapper) {
        return this.producePublisher(mapper);
    }

    public <O> MultiFlatten<T, O> producePublisher(Function<? super T, ? extends Publisher<? extends O>> mapper) {
        return new MultiFlatten(this.upstream, ParameterValidation.nonNull(mapper, "mapper"), 1, false);
    }

    public <O> MultiFlatten<T, O> produceIterable(Function<? super T, ? extends Iterable<? extends O>> mapper) {
        ParameterValidation.nonNull(mapper, "mapper");
        return this.producePublisher(x -> {
            Iterable iterable = (Iterable)mapper.apply(x);
            if (iterable == null) {
                return Multi.createFrom().failure(new NullPointerException("The mapper returned `null`"));
            }
            return Multi.createFrom().iterable(iterable);
        });
    }

    public <O> MultiFlatten<T, O> produceUni(Function<? super T, ? extends Uni<? extends O>> mapper) {
        ParameterValidation.nonNull(mapper, "mapper");
        Function<Object, Publisher> wrapper = res -> ((Uni)mapper.apply(res)).toMulti();
        return new MultiFlatten(this.upstream, wrapper, 1, false);
    }

    public <O> MultiFlatten<T, O> produceCompletionStage(Function<? super T, ? extends CompletionStage<? extends O>> mapper) {
        ParameterValidation.nonNull(mapper, "mapper");
        Function<Object, Publisher> wrapper = res -> Multi.createFrom().emitter(emitter -> {
            CompletionStage stage;
            try {
                stage = (CompletionStage)mapper.apply(res);
            }
            catch (Exception e) {
                emitter.fail(e);
                return;
            }
            if (stage == null) {
                throw new NullPointerException("The supplier returned `null`");
            }
            emitter.onTermination(() -> stage.toCompletableFuture().cancel(false));
            stage.whenComplete((r, f) -> {
                if (f != null) {
                    emitter.fail((Throwable)f);
                } else if (r != null) {
                    emitter.emit(r);
                    emitter.complete();
                } else {
                    emitter.fail(new NullPointerException("The completion stage redeemed `null`"));
                }
            });
        }, BackPressureStrategy.LATEST);
        return new MultiFlatten(this.upstream, wrapper, 1, false);
    }

    public Multi<Void> ignore() {
        return new MultiIgnoreOp<T>(this.upstream);
    }

    public Uni<Void> ignoreAsUni() {
        return new MultiIgnoreOp<T>(this.upstream).toUni();
    }

    public <O> Multi<O> castTo(Class<O> target) {
        ParameterValidation.nonNull(target, "target");
        return this.apply(target::cast);
    }

    public <S> Multi<S> scan(Supplier<S> initialStateProducer, BiFunction<S, ? super T, S> accumulator) {
        return new MultiScanWithSeedOp<T, S>(this.upstream, initialStateProducer, accumulator);
    }

    public Multi<T> scan(BinaryOperator<T> accumulator) {
        return new MultiScanOp<T>(this.upstream, accumulator);
    }
}

