/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.queues.SpscArrayQueue;
import io.smallrye.mutiny.operators.multi.MultiFlatMapOp;
import java.util.function.Function;
import org.reactivestreams.Publisher;

public class MultiFlatten<I, O> {
    private final Function<? super I, ? extends Publisher<? extends O>> mapper;
    private final Multi<I> upstream;
    private final int requests;
    private final boolean collectFailureUntilCompletion;

    MultiFlatten(Multi<I> upstream, Function<? super I, ? extends Publisher<? extends O>> mapper, int requests, boolean collectFailures) {
        this.upstream = upstream;
        this.mapper = mapper;
        this.requests = requests;
        this.collectFailureUntilCompletion = collectFailures;
    }

    public MultiFlatten<I, O> collectFailures() {
        return new MultiFlatten<I, O>(this.upstream, this.mapper, this.requests, true);
    }

    public MultiFlatten<I, O> withRequests(int req) {
        return new MultiFlatten<I, O>(this.upstream, this.mapper, ParameterValidation.positive(req, "req"), this.collectFailureUntilCompletion);
    }

    public Multi<O> merge() {
        return new MultiFlatMapOp(this.upstream, this.mapper, this.collectFailureUntilCompletion, this.requests, () -> new SpscArrayQueue(256), () -> new SpscArrayQueue(256));
    }

    public Multi<O> merge(int concurrency) {
        return new MultiFlatMapOp(this.upstream, this.mapper, this.collectFailureUntilCompletion, concurrency, () -> new SpscArrayQueue(256), () -> new SpscArrayQueue(256));
    }

    public Multi<O> concatenate() {
        return new MultiFlatMapOp(this.upstream, this.mapper, this.collectFailureUntilCompletion, 1, () -> new SpscArrayQueue(256), () -> new SpscArrayQueue(256));
    }
}

