/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.converters.MultiConverter;
import io.smallrye.mutiny.groups.MultiTimePeriod;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.AbstractMulti;
import io.smallrye.mutiny.operators.multi.builders.CollectionBasedMulti;
import io.smallrye.mutiny.operators.multi.builders.DeferredMulti;
import io.smallrye.mutiny.operators.multi.builders.EmitterBasedMulti;
import io.smallrye.mutiny.operators.multi.builders.EmptyMulti;
import io.smallrye.mutiny.operators.multi.builders.FailedMulti;
import io.smallrye.mutiny.operators.multi.builders.IterableBasedMulti;
import io.smallrye.mutiny.operators.multi.builders.NeverMulti;
import io.smallrye.mutiny.subscription.BackPressureStrategy;
import io.smallrye.mutiny.subscription.MultiEmitter;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;

public class MultiCreate {
    public static final MultiCreate INSTANCE = new MultiCreate();

    private MultiCreate() {
    }

    public <I, T> Multi<T> converter(MultiConverter<I, T> converter, I instance) {
        return converter.from(instance);
    }

    public <T> Multi<T> completionStage(CompletionStage<? extends T> stage) {
        CompletionStage actual = ParameterValidation.nonNull(stage, "stage");
        return this.completionStage(() -> actual);
    }

    public <T> Multi<T> completionStage(Supplier<? extends CompletionStage<? extends T>> supplier) {
        ParameterValidation.nonNull(supplier, "supplier");
        return this.emitter(emitter -> {
            CompletionStage stage;
            try {
                stage = (CompletionStage)supplier.get();
            }
            catch (Exception e) {
                emitter.fail(e);
                return;
            }
            if (stage == null) {
                throw new NullPointerException("The supplier returned `null`");
            }
            emitter.onTermination(() -> stage.toCompletableFuture().cancel(false));
            stage.whenComplete((r, f) -> {
                if (f != null) {
                    emitter.fail((Throwable)f);
                } else if (r != null) {
                    emitter.emit(r);
                }
                emitter.complete();
            });
        }, BackPressureStrategy.LATEST);
    }

    public <T> Multi<T> publisher(Publisher<T> publisher) {
        final Publisher<T> actual = ParameterValidation.nonNull(publisher, "publisher");
        return new AbstractMulti<T>(){

            @Override
            protected Publisher<T> publisher() {
                return actual;
            }
        };
    }

    public <T> Multi<T> uni(Uni<T> uni) {
        return ParameterValidation.nonNull(uni, "uni").toMulti();
    }

    public <T> Multi<T> item(Supplier<? extends T> supplier) {
        Supplier actual = ParameterValidation.nonNull(supplier, "supplier");
        return this.emitter(emitter -> {
            Object item;
            try {
                item = actual.get();
            }
            catch (RuntimeException e) {
                emitter.fail(e);
                return;
            }
            if (item != null) {
                emitter.emit(item);
            }
            emitter.complete();
        });
    }

    public <T> Multi<T> items(Supplier<? extends Stream<? extends T>> supplier) {
        Supplier actual = ParameterValidation.nonNull(supplier, "supplier");
        return this.emitter(emitter -> {
            Stream stream;
            try {
                stream = (Stream)actual.get();
            }
            catch (RuntimeException e) {
                emitter.fail(e);
                return;
            }
            if (stream == null) {
                emitter.fail(new NullPointerException("The supplier returned `null`"));
                return;
            }
            AtomicBoolean failed = new AtomicBoolean();
            ((Stream)stream.sequential()).forEach(it -> {
                if (it == null) {
                    failed.set(true);
                    emitter.fail(new IllegalArgumentException("The produceIterable contained a `null` value"));
                    return;
                }
                emitter.emit(it);
            });
            if (!failed.get()) {
                emitter.complete();
            }
        });
    }

    public <T> Multi<T> item(T item) {
        return this.item((T)((Supplier<Object>)() -> item));
    }

    @SafeVarargs
    public final <T> Multi<T> items(T ... items) {
        return new CollectionBasedMulti<T>(ParameterValidation.nonNull(items, "items"));
    }

    public <T> Multi<T> iterable(Iterable<T> iterable) {
        return new IterableBasedMulti<T>(ParameterValidation.nonNull(iterable, "produceIterable"));
    }

    public <T> Multi<T> items(Stream<T> items) {
        Stream stream = ParameterValidation.nonNull(items, "items");
        return this.items(() -> stream);
    }

    public <T> Multi<T> optional(Optional<T> optional) {
        Optional actual = ParameterValidation.nonNull(optional, "optional");
        return this.item((T)((Supplier<Object>)() -> actual.orElse(null)));
    }

    public <T> Multi<T> optional(Supplier<Optional<T>> supplier) {
        Supplier actual = ParameterValidation.nonNull(supplier, "supplier");
        return this.item((T)((Supplier<Object>)() -> ((Optional)actual.get()).orElse(null)));
    }

    public <T> Multi<T> emitter(Consumer<MultiEmitter<? super T>> consumer) {
        return this.emitter(consumer, BackPressureStrategy.BUFFER);
    }

    public <T> Multi<T> emitter(Consumer<MultiEmitter<? super T>> consumer, BackPressureStrategy strategy) {
        Consumer<MultiEmitter<? super T>> actual = ParameterValidation.nonNull(consumer, "consumer");
        return new EmitterBasedMulti<T>(actual, ParameterValidation.nonNull(strategy, "strategy"));
    }

    public <T> Multi<T> deferred(Supplier<? extends Multi<? extends T>> supplier) {
        return new DeferredMulti(ParameterValidation.nonNull(supplier, "supplier"));
    }

    public <T> Multi<T> failure(Throwable failure) {
        Throwable exception = ParameterValidation.nonNull(failure, "failure");
        return this.failure(() -> exception);
    }

    public <T> Multi<T> failure(Supplier<Throwable> supplier) {
        return new FailedMulti(supplier);
    }

    public <T> Multi<T> nothing() {
        return NeverMulti.never();
    }

    public <T> Multi<T> empty() {
        return EmptyMulti.empty();
    }

    public MultiTimePeriod ticks() {
        return new MultiTimePeriod();
    }

    public Multi<Integer> range(int startInclusive, int endExclusive) {
        if (endExclusive <= startInclusive) {
            throw new IllegalArgumentException("end must be greater than start");
        }
        return Multi.createFrom().iterable(() -> IntStream.range(startInclusive, endExclusive).iterator());
    }
}

