/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi.multicast;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.AbstractMulti;
import io.smallrye.mutiny.operators.multi.multicast.ConnectableMulti;
import io.smallrye.mutiny.operators.multi.multicast.ConnectableMultiConnection;
import io.smallrye.mutiny.operators.multi.multicast.MultiReferenceCountSubscriber;
import io.smallrye.mutiny.subscription.Cancellable;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public class MultiReferenceCount<T>
extends AbstractMulti<T>
implements Multi<T> {
    private final ConnectableMulti<T> upstream;
    private final int numberOfSubscribers;
    private final Duration duration;
    private final ScheduledExecutorService executor;
    private ConnectableMultiConnection connection;

    public MultiReferenceCount(ConnectableMulti<T> upstream) {
        this(upstream, 1, null);
    }

    public MultiReferenceCount(ConnectableMulti<T> upstream, int numberOfSubscribers, Duration duration) {
        this.upstream = upstream;
        this.numberOfSubscribers = numberOfSubscribers;
        this.duration = duration;
        this.executor = Infrastructure.getDefaultWorkerPool();
    }

    @Override
    protected Publisher<T> publisher() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(Subscriber<? super T> s) {
        boolean connect;
        ConnectableMultiConnection conn;
        MultiReferenceCount multiReferenceCount = this;
        synchronized (multiReferenceCount) {
            conn = this.connection;
            if (conn == null) {
                this.connection = conn = new ConnectableMultiConnection(this);
            }
            conn.cancelTimerIf0();
            connect = conn.shouldConnectAfterIncrement(this.numberOfSubscribers);
        }
        this.upstream.subscribe(new MultiReferenceCountSubscriber<T>(s, this, conn));
        if (connect) {
            this.upstream.connect(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel(ConnectableMultiConnection connection) {
        MultiReferenceCount multiReferenceCount = this;
        synchronized (multiReferenceCount) {
            if (this.connection == null || this.connection != connection) {
                return;
            }
            long count = connection.decrement();
            if (count != 0L || !connection.isConnected()) {
                return;
            }
            if (this.duration == null || this.duration.toMillis() == 0L) {
                this.timeout(connection);
                return;
            }
        }
        ScheduledFuture<?> future = this.executor.schedule(connection, this.duration.toMillis(), TimeUnit.MILLISECONDS);
        connection.setTimer(() -> future.cancel(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminated(ConnectableMultiConnection connection) {
        MultiReferenceCount multiReferenceCount = this;
        synchronized (multiReferenceCount) {
            if (this.connection != null && this.connection == connection) {
                this.connection = null;
                connection.cancel();
            }
            if (connection.decrementAndReached0() && this.upstream instanceof Cancellable) {
                ((Cancellable)((Object)this.upstream)).cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void timeout(ConnectableMultiConnection connection) {
        MultiReferenceCount multiReferenceCount = this;
        synchronized (multiReferenceCount) {
            if (connection.getSubscriberCount() == 0L && connection == this.connection) {
                this.connection = null;
                connection.cancel();
                if (this.upstream instanceof Cancellable) {
                    ((Cancellable)((Object)this.upstream)).cancel();
                }
            }
        }
    }
}

