/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.SwitchableSubscriptionSubscriber;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.reactivestreams.Subscriber;

public final class MultiScanWithSeedOp<T, R>
extends AbstractMultiOperator<T, R> {
    private final BiFunction<R, ? super T, R> accumulator;
    private final Supplier<R> seed;

    public MultiScanWithSeedOp(Multi<? extends T> upstream, Supplier<R> seed, BiFunction<R, ? super T, R> accumulator) {
        super(upstream);
        this.seed = ParameterValidation.nonNull(seed, "seed");
        this.accumulator = ParameterValidation.nonNull(accumulator, "accumulator");
    }

    @Override
    public void subscribe(Subscriber<? super R> downstream) {
        ScanSubscriber<T, R> subscriber = new ScanSubscriber<T, R>(this.upstream, downstream, this.accumulator, this.seed);
        downstream.onSubscribe(subscriber);
        if (!subscriber.isCancelled()) {
            subscriber.onComplete();
        }
    }

    private static final class ScanSeedProcessor<T, R>
    extends MultiOperatorProcessor<T, R> {
        private final BiFunction<R, ? super T, R> accumulator;
        R current;

        ScanSeedProcessor(Subscriber<? super R> downstream, BiFunction<R, ? super T, R> accumulator, R initial) {
            super(downstream);
            this.accumulator = accumulator;
            this.current = initial;
        }

        @Override
        public void onComplete() {
            super.onComplete();
            this.current = null;
        }

        @Override
        public void onError(Throwable failure) {
            super.onError(failure);
            this.current = null;
        }

        public void onNext(T t) {
            if (this.isDone()) {
                return;
            }
            R r = this.current;
            try {
                r = this.accumulator.apply(r, t);
            }
            catch (Throwable e) {
                this.onError(e);
                return;
            }
            if (r == null) {
                this.onError(new NullPointerException("The accumulator returned a null value"));
                return;
            }
            this.downstream.onNext(r);
            this.current = r;
        }
    }

    static final class ScanSubscriber<T, R>
    extends SwitchableSubscriptionSubscriber<R> {
        private final Multi<? extends T> upstream;
        private final Supplier<R> initialSupplier;
        private final BiFunction<R, ? super T, R> accumulator;
        private final AtomicInteger wip = new AtomicInteger();
        long produced;
        private ScanSeedProcessor<T, R> subscriber;

        ScanSubscriber(Multi<? extends T> upstream, Subscriber<? super R> downstream, BiFunction<R, ? super T, R> accumulator, Supplier<R> seed) {
            super(downstream);
            this.upstream = upstream;
            this.accumulator = accumulator;
            this.initialSupplier = seed;
        }

        @Override
        public void onComplete() {
            if (this.wip.getAndIncrement() == 0) {
                do {
                    if (this.isCancelled()) {
                        return;
                    }
                    if (this.subscriber != null && this.currentUpstream.get() == this.subscriber) {
                        this.downstream.onComplete();
                        return;
                    }
                    long p = this.produced;
                    if (p != 0L) {
                        this.produced = 0L;
                        this.emitted(p);
                    }
                    if (this.subscriber == null) {
                        R initialValue;
                        try {
                            initialValue = this.initialSupplier.get();
                        }
                        catch (Throwable e) {
                            this.onError(e);
                            return;
                        }
                        if (initialValue == null) {
                            this.onError(new NullPointerException("The seed cannot be `null`"));
                            return;
                        }
                        this.onSubscribe(Subscriptions.single(this, initialValue));
                        this.subscriber = new ScanSeedProcessor<T, R>(this, this.accumulator, initialValue);
                    } else {
                        this.upstream.subscribe(this.subscriber);
                    }
                    if (!this.isCancelled()) continue;
                    return;
                } while (this.wip.decrementAndGet() != 0);
            }
        }

        public void onNext(R r) {
            ++this.produced;
            this.downstream.onNext(r);
        }
    }
}

